/**
 * Institution: Georgia Institute of Technology - ECE Department - Senior Design II
 * Team: AH3
 * Created: 3/24/2015
 * Last Edit: 3/26/2015
 * By: Taylor Andrews, Luke Panayioto
**/

#include "DX6iController.h"

DX6iController::DX6iController(pwmPin) : _pwmPin(pwmPin) {
    pulseInterval = 0;
    nChannels = 9;
    
    Throttle_Uptime = 700;           //1   700 / 1100 / 1500                                    // Throttle
    Roll_Uptime = 1100;              //2   700 / 1100 / 1500 (R/L)                              // Roll
    Pitch_Uptime = 1100;             //3   770 / 1170 / 1550 (B/F)                              // Pitch
    Yaw_Uptime = 1100;               //4   700 / 1090 / 1500 (R/L)                              // Yaw
    Stabilize_Uptime = 1100;         //5  LLLL / MMMM / 1500 (3,2,1)                            
    Enable_Uptime = 1500;            //6   700 / ---- / 1500 (Off/On) Note: Bind I Button      
    Extra_Uptime = 1100;             //7  LLLL / 1100 / HHHH                                    // IDK
    Extra2_Uptime = 1100;            //8  LLLL / 1100 / HHHH                                    // IDK
    Remainder_Uptime = 22000 - ((pulseInterval * nChannels) + Throttle_Uptime + Roll_Uptime + Pitch_Uptime + Yaw_Uptime + Enable_Uptime + Stabilize_Uptime + Extra_Uptime + Extra2_Uptime);

    mThrottleTrim = 0;
    mRollTrim = 0;
    mPitchTrim = 0;
    mYawTrim = 0;
}

void DX6iController::generateSignal(int externalDelay) {
    //Big pulse
    // long remainder uptime (0)
    _pwmPin = 1; //Soft pwm
    wait_us(Remainder_Uptime - externalDelay);
    _pwmPin = 0;
    wait_us(pulseInterval);
    
    // Throttle pulse (1)
    _pwmPin = 1;
    wait_us(Throttle_Uptime + mThrottleTrim);
    _pwmPin = 0;
    wait_us(pulseInterval);
    
    // Roll pulse (2)
    _pwmPin = 1;
    wait_us(Roll_Uptime + mRollTrim);
    _pwmPin = 0;
    wait_us(pulseIntervalDelay);

    // Pitch pulse (3)
    _pwmPin = 1;
    wait_us(Pitch_Uptime + mPitchTrim);
    _pwmPin = 0;
    wait_us(pulseIntervalDelay);
    
    // Yaw pulse (4)
    _pwmPin = 1;
    wait_us(Yaw_Uptime + mYawTrim);
    _pwmPin = 0;
    wait_us(pulseInterval);
    
    // Stability pulse (5)
    _pwmPin = 1;
    wait_us(Stabilize_Uptime);
    _pwmPin = 0;
    wait_us(pulseInterval);
    
    // Enable pulse (6)
    _pwmPin = 1;
    wait_us(Enable_Uptime);
    _pwmPin = 0;
    wait_us(pulseInterval);

    _pwmPin = 1;
    wait_us(Extra_Uptime);
    _pwmPin = 0;
    wait_us(pulseInterval);
    
    _pwmPin = 1;
    wait_us(Extra2_Uptime);
    _pwmPin = 0;
    wait_us(pulseInterval);
}

// TODO: ensure that new values are in an acceptable range
void DX6iController::updateThrottle(int newThrottle) {
    Throttle_Uptime = newThrottle;
    updateRemainder();
}

void DX6iController::updateRoll(int newRoll) {
    Roll_Uptime = newRoll;
    updateRemainder();
}

void DX6iController::updatePitch(int newPitch) {
    Pitch_Uptime = newPitch;
    updateRemainder();
}

void DX6iController::updateYaw(int newYaw) {
    Yaw_Uptime = newYaw;
    updateRemainder();
}

void DX6iController::updateRemainder() {
    Remainder_Uptime = 22000 - (pulseInterval*nChannels + Throttle_Uptime + Roll_Uptime + Pitch_Uptime + Yaw_Uptime
                         + Enable_Uptime + Stabilize_Uptime + Extra_Uptime + Extra2_Uptime
                         + mThrottleTrim + mRollTrim + mPitchTrim + mYawTrim);
}

void DX6iController::updateThrottleTrim(int newThrottleTrim) {
    mThrottleTrim = newThrottleTrim;
}

void DX6iController::updateRollTrim(int newRollTrim) {
    mRollTrim = newRollTrim;
}

void DX6iController::updatePitchTrim(int newPitchTrim) {
    mPitchTrim = newPitchTrim;
}

void DX6iController::updateYawTrim(int newYawTrim) {
    mYawTrim = newYawTrim;
}