#ifndef _ROS_openlab_mobileRobot_h
#define _ROS_openlab_mobileRobot_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace openlab
{

  class mobileRobot : public ros::Msg
  {
    public:
      typedef float _cmd_velocity_linx_type;
      _cmd_velocity_linx_type cmd_velocity_linx;
      typedef float _cmd_velocity_angz_type;
      _cmd_velocity_angz_type cmd_velocity_angz;
      typedef float _real_velocity_linx_type;
      _real_velocity_linx_type real_velocity_linx;
      typedef float _real_velocity_angz_type;
      _real_velocity_angz_type real_velocity_angz;
      typedef float _pwm_1_type;
      _pwm_1_type pwm_1;
      typedef float _pwm_2_type;
      _pwm_2_type pwm_2;
      typedef float _dc_current_1_type;
      _dc_current_1_type dc_current_1;
      typedef float _dc_current_2_type;
      _dc_current_2_type dc_current_2;
      typedef int32_t _encoder_1_type;
      _encoder_1_type encoder_1;
      typedef int32_t _encoder_2_type;
      _encoder_2_type encoder_2;

    mobileRobot():
      cmd_velocity_linx(0),
      cmd_velocity_angz(0),
      real_velocity_linx(0),
      real_velocity_angz(0),
      pwm_1(0),
      pwm_2(0),
      dc_current_1(0),
      dc_current_2(0),
      encoder_1(0),
      encoder_2(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      union {
        float real;
        uint32_t base;
      } u_cmd_velocity_linx;
      u_cmd_velocity_linx.real = this->cmd_velocity_linx;
      *(outbuffer + offset + 0) = (u_cmd_velocity_linx.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_cmd_velocity_linx.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_cmd_velocity_linx.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_cmd_velocity_linx.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->cmd_velocity_linx);
      union {
        float real;
        uint32_t base;
      } u_cmd_velocity_angz;
      u_cmd_velocity_angz.real = this->cmd_velocity_angz;
      *(outbuffer + offset + 0) = (u_cmd_velocity_angz.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_cmd_velocity_angz.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_cmd_velocity_angz.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_cmd_velocity_angz.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->cmd_velocity_angz);
      union {
        float real;
        uint32_t base;
      } u_real_velocity_linx;
      u_real_velocity_linx.real = this->real_velocity_linx;
      *(outbuffer + offset + 0) = (u_real_velocity_linx.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_real_velocity_linx.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_real_velocity_linx.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_real_velocity_linx.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->real_velocity_linx);
      union {
        float real;
        uint32_t base;
      } u_real_velocity_angz;
      u_real_velocity_angz.real = this->real_velocity_angz;
      *(outbuffer + offset + 0) = (u_real_velocity_angz.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_real_velocity_angz.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_real_velocity_angz.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_real_velocity_angz.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->real_velocity_angz);
      union {
        float real;
        uint32_t base;
      } u_pwm_1;
      u_pwm_1.real = this->pwm_1;
      *(outbuffer + offset + 0) = (u_pwm_1.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_pwm_1.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_pwm_1.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_pwm_1.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->pwm_1);
      union {
        float real;
        uint32_t base;
      } u_pwm_2;
      u_pwm_2.real = this->pwm_2;
      *(outbuffer + offset + 0) = (u_pwm_2.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_pwm_2.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_pwm_2.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_pwm_2.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->pwm_2);
      union {
        float real;
        uint32_t base;
      } u_dc_current_1;
      u_dc_current_1.real = this->dc_current_1;
      *(outbuffer + offset + 0) = (u_dc_current_1.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_dc_current_1.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_dc_current_1.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_dc_current_1.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->dc_current_1);
      union {
        float real;
        uint32_t base;
      } u_dc_current_2;
      u_dc_current_2.real = this->dc_current_2;
      *(outbuffer + offset + 0) = (u_dc_current_2.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_dc_current_2.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_dc_current_2.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_dc_current_2.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->dc_current_2);
      union {
        int32_t real;
        uint32_t base;
      } u_encoder_1;
      u_encoder_1.real = this->encoder_1;
      *(outbuffer + offset + 0) = (u_encoder_1.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_encoder_1.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_encoder_1.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_encoder_1.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->encoder_1);
      union {
        int32_t real;
        uint32_t base;
      } u_encoder_2;
      u_encoder_2.real = this->encoder_2;
      *(outbuffer + offset + 0) = (u_encoder_2.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_encoder_2.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_encoder_2.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_encoder_2.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->encoder_2);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      union {
        float real;
        uint32_t base;
      } u_cmd_velocity_linx;
      u_cmd_velocity_linx.base = 0;
      u_cmd_velocity_linx.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_cmd_velocity_linx.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_cmd_velocity_linx.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_cmd_velocity_linx.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->cmd_velocity_linx = u_cmd_velocity_linx.real;
      offset += sizeof(this->cmd_velocity_linx);
      union {
        float real;
        uint32_t base;
      } u_cmd_velocity_angz;
      u_cmd_velocity_angz.base = 0;
      u_cmd_velocity_angz.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_cmd_velocity_angz.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_cmd_velocity_angz.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_cmd_velocity_angz.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->cmd_velocity_angz = u_cmd_velocity_angz.real;
      offset += sizeof(this->cmd_velocity_angz);
      union {
        float real;
        uint32_t base;
      } u_real_velocity_linx;
      u_real_velocity_linx.base = 0;
      u_real_velocity_linx.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_real_velocity_linx.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_real_velocity_linx.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_real_velocity_linx.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->real_velocity_linx = u_real_velocity_linx.real;
      offset += sizeof(this->real_velocity_linx);
      union {
        float real;
        uint32_t base;
      } u_real_velocity_angz;
      u_real_velocity_angz.base = 0;
      u_real_velocity_angz.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_real_velocity_angz.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_real_velocity_angz.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_real_velocity_angz.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->real_velocity_angz = u_real_velocity_angz.real;
      offset += sizeof(this->real_velocity_angz);
      union {
        float real;
        uint32_t base;
      } u_pwm_1;
      u_pwm_1.base = 0;
      u_pwm_1.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_pwm_1.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_pwm_1.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_pwm_1.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->pwm_1 = u_pwm_1.real;
      offset += sizeof(this->pwm_1);
      union {
        float real;
        uint32_t base;
      } u_pwm_2;
      u_pwm_2.base = 0;
      u_pwm_2.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_pwm_2.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_pwm_2.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_pwm_2.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->pwm_2 = u_pwm_2.real;
      offset += sizeof(this->pwm_2);
      union {
        float real;
        uint32_t base;
      } u_dc_current_1;
      u_dc_current_1.base = 0;
      u_dc_current_1.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_dc_current_1.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_dc_current_1.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_dc_current_1.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->dc_current_1 = u_dc_current_1.real;
      offset += sizeof(this->dc_current_1);
      union {
        float real;
        uint32_t base;
      } u_dc_current_2;
      u_dc_current_2.base = 0;
      u_dc_current_2.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_dc_current_2.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_dc_current_2.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_dc_current_2.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->dc_current_2 = u_dc_current_2.real;
      offset += sizeof(this->dc_current_2);
      union {
        int32_t real;
        uint32_t base;
      } u_encoder_1;
      u_encoder_1.base = 0;
      u_encoder_1.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_encoder_1.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_encoder_1.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_encoder_1.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->encoder_1 = u_encoder_1.real;
      offset += sizeof(this->encoder_1);
      union {
        int32_t real;
        uint32_t base;
      } u_encoder_2;
      u_encoder_2.base = 0;
      u_encoder_2.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_encoder_2.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_encoder_2.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_encoder_2.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->encoder_2 = u_encoder_2.real;
      offset += sizeof(this->encoder_2);
     return offset;
    }

    const char * getType(){ return "openlab/mobileRobot"; };
    const char * getMD5(){ return "5e54beb06e233db01abe11e2006b8b2e"; };

  };

}
#endif
