#include "mbed.h"
#include "rtos.h"
#include "cmsis_os.h"
#include <ros.h>
#include <std_msgs/String.h>



ros::NodeHandle  nh;
std_msgs::String str_msg;
ros::Publisher chatter("chatter", &str_msg);


DigitalOut led1(LED1);

void print_thread(void const *argument)
{
    char hello[13] = "hello world!"; 
    while (true) {
        Thread::wait(1000);
        str_msg.data = hello;
        chatter.publish( &str_msg );
        nh.spinOnce();
       
    }
}

int main()
{
    nh.initNode();
    nh.advertise(chatter);
    
  
    Thread thread(print_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    
    while (true) {
        led1 = !led1;
        Thread::wait(500);
    }
    
}
