#include "mbed.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdint.h>
#include "GPS.h"
#include "MDM.h"
#include "main.h"
#include "coap_msg.h"
#include "coap_client.h"
    
extern "C" {
    
    #include "rtc_api.h"
}
//
//----------------------------------------------------------------------------------------------------------------------
#define SIMPIN          "1922"
#define APN             NULL
#define USERNAME        NULL
#define PASSWORD        NULL 
//----------------------------------------------------------------------------------------------------------------------
int pport = 5685;
const char* host = "coap.me";
//----------------------------------------------------------------------------------------------------------------------
int                     ssocket;
MDMParser::IP           ipp;
MDMSerial*              gmdm = NULL;
DigitalOut              myled(LED);
unsigned long           ulGPSRxCntr=0, ulGPSTxCntr=0 ;      //-- Asset
unsigned long           ulGSMRxCntr=0, ulGSMTxCntr=0 ;      //-- Asset
unsigned long           ulTotalRxCntr=0,ulTotalTxCntr=0;    //-- Asset
char                    caLssFinalAssetMsg[150];
double                  dLatitude=31.47691,dLongitude=74.34259;
static unsigned int     uiWakeupCounter=0,uiWatchdogCounter=0;
unsigned char           ucBtteryLevel=0;
MDMParser::DevStatus    devStatus={};

bool                    bSendingDataFlag = true;
bool                    bSleepModeFlag = true;
//bool                  bHeartBeatFlag = false;
//bool                  bAlarmIntervalFlag = true;

//unsigned int          uiAlarmIntervalCounter = 0;
//unsigned int          uiHeartBeatCounter = 0;

char ucReturnCode[10];     //Return code array
int alarmtime = 1495698480;//2017-3-29-11:56:7
//----------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------
/*
void timer0_init(int sec)
{
    LPC_SC->PCONP |=1<1;            //timer0 power on
    LPC_TIM0->MR0 = sec * 23980000; //1sec * sec
    LPC_TIM0->MCR = 1;              //interrupt and reset control
                                    //3 = Interrupt & reset timer0 on match
                                    //1 = Interrupt only, no reset of timer0
    NVIC_EnableIRQ(TIMER0_IRQn);    //enable timer0 interrupt
    LPC_TIM0->TCR = 1;              //enable Timer0
    //printf("Done timer_init\n\r");
}

extern "C" void TIMER0_IRQHandler (void)
{
    if((LPC_TIM0->IR & 0x01) == 0x01)   // if MR0 interrupt, proceed
    {
        LPC_TIM0->IR |= 1 << 0;         // Clear MR0 interrupt flag
        printf("Timer 0 interrupt generated 10 sec\r\n");
        LPC_TIM0->TCR = 0; 
    }
}
*/
//----------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------

void rtc_setup(time_t t, unsigned int sec)
{
    struct tm *timeinfo = localtime(&t);
    unsigned int min;
    
    rtc_init();

    rtc_write(alarmtime);//2017-3-29-11:56:7
    
    //min = sec/60;
    //sec = sec%60;
     //set alarm time
    LPC_RTC->ALSEC = timeinfo->tm_sec+sec;//10 sec
    //LPC_RTC->ALMIN = timeinfo->tm_min+min;//10 sec

    LPC_RTC->AMR &= (~(1 << 0)) & 0xFF;

    LPC_RTC->ILR = (1 << 0) | (1 << 1);
    
    printf("RTC Alarm Time Set\r\n");

    NVIC_EnableIRQ(RTC_IRQn);

    do 
    {
        LPC_RTC->CCR |= (1 << 0);
    } 
    while ((LPC_RTC->CCR & (1 << 0)) == 0);

    printf("RTC setup successfully\r\n");
}

extern "C" void RTC_IRQHandler (void)
{
    // Check for alarm match
    if (LPC_RTC->ILR & (1 << 1))
    {
        LPC_RTC->ILR = (1 << 1);
        printf("RTC interrupt generated 10 sec\r\n");
    }
}

//----------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------

int main(void)
{    
    int ret;
    char buf[150] = "";

    // Create the GPS object
#if 1   // use GPSI2C class
    GPSI2C gps;
#else   // or GPSSerial class 
    GPSSerial gps; 
#endif

    MDMSerial mdm;            
    gmdm = &mdm;
    us_ticker_init();
    

while(1)
{
    wait(5);
    //if(bAlarmIntervalFlag || bHeartBeatFlag)
    //{ 
        if(initialize_modem())
        {
            if(bSendingDataFlag)//&& bAlarmIntervalFlag)
            {
                //bAlarmIntervalFlag = false;
                while( (ret = gps.getMessage(buf, sizeof(buf))) > 0)
                {
                    int len = LENGTH(ret);
                    ulGPSRxCntr = len;
                    if( (PROTOCOL(ret)==GPSParser::NMEA) && (len > 6) )
                    {
                        // talker is $GA=Galileo $GB=Beidou $GL=Glonass $GN=Combined $GP=GPS
                        if( (buf[0]=='$') || buf[1]=='G' )
                        {
                            #define _CHECK_TALKER(s) ((buf[3] == s[0]) && (buf[4] == s[1]) && (buf[5] == s[2]))
                            if( _CHECK_TALKER("GLL") ) 
                            {
                                char ch;
                                if( gps.getNmeaAngle(1,buf,len,dLatitude) && gps.getNmeaAngle(3,buf,len,dLongitude) && gps.getNmeaItem(6,buf,len,ch) && ch == 'A' ) 
                                {
                                    printf( "GPS Location: %.5f %.5f\r\n", dLatitude, dLongitude );
                                    break;
                                    //sprintf(link, "I am here!\n" "https://maps.google.com/?q=%.5f,%.5f", la, lo);
                                } else 
                                {
                                    dLatitude = 0.0;
                                    dLongitude = 0.0;
                                }
                            } 
                            //else if(_CHECK_TALKER("GGA") || _CHECK_TALKER("GNS") ) 
                            //{
                                //double a = 0;
                                //if (gps.getNmeaItem(9,buf,len,a)) // altitude msl [m]
                                //    printf("GPS Altitude: %.1f\r\n", a);
                            //} 
                            //else if( _CHECK_TALKER("VTG") ) 
                            //{
                                //double s = 0;
                                //if( gps.getNmeaItem(7,buf,len,s) ) // speed [km/h]
                                //    printf( "GPS Speed: %.1f\r\n", s );
                            //}
                        }
                    } 
                    else 
                    {
                        printf("GPS Packet error\r\n");
                        dLatitude = 0.0;
                        dLongitude = 0.0;
                    }
                }
                memset(caLssFinalAssetMsg, '\0', sizeof(caLssFinalAssetMsg));
                sprintf( caLssFinalAssetMsg, "$AQLSS,01,%s,%s,%.5f,%.5f,%lu,%lu,%d,%d,%d*xx", 
                                            devStatus.imei,devStatus.imsi, dLatitude,dLongitude,ulGPSRxCntr,ulGPSTxCntr,uiWakeupCounter,uiWatchdogCounter,ucBtteryLevel);
                printf( "AssetMsg: %s\r\n", caLssFinalAssetMsg );
            }
            else // else if(bHeartBeatFlag)
            {
                //bHeartBeatFlag = false;
                sprintf( caLssFinalAssetMsg, "$AQLSS,02,%s,%s*xx",devStatus.imei,devStatus.imsi);
                printf( "HeartBeat: %s\r\n", caLssFinalAssetMsg );
            }
            
            ssocket = mdm.socketSocket(MDMParser::IPPROTO_UDP, pport);
            if( ssocket >= 0 ) 
            {
                mdm.socketSetBlocking(ssocket, 10);
                ipp = 0x97092263;//0x052753CE;
                if (PASS == test_exchange_func(caLssFinalAssetMsg,strlen(caLssFinalAssetMsg),ucReturnCode))
                {
                    printf("\r\n-----------------<pass>-----------------\n");           
                }                
                else
                    printf("\r\n-----------------<fail>-----------------\n");

                mdm.socketFree(ssocket);
                responce_checker(); 
            }

            mdm.disconnect();
            /*mdm.powerOff();*/
        
            if(bSleepModeFlag)
            {
                 rtc_setup(alarmtime,10);
                printf("Enter Sleep Mode\r\n");
                hal_sleep();
                printf("Exit Sleep Mode\r\n");
                myled = !myled;
                uiWakeupCounter++;
            }
            
            /*if(bSendingDataFlag)
                wait( 10 );
            else
                wait( 60 );
            myled = !myled;*/
        }
    //}
}
    return 0;
}
//----------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------------l
int initialize_modem(void)
{
    bool mdmOk = gmdm->init(SIMPIN, &devStatus);
    gmdm->dumpDevStatus(&devStatus);
    if (mdmOk)
    {
        MDMParser::IP ipp = gmdm->join(APN,USERNAME,PASSWORD);  // join the internet connection 
        if (ipp == NOIP)
        {
            printf( "AQ-LSS: Modem NOT initialized\n" );
            gmdm->powerOff();
            return 0;
        }
        else
        {
            printf( "AQ-LSS: Modem initialized\n" );  
            //ussd_send();
            return 1;   
        }
    }
    else
    {
        return 0;
    }
}
int recv(int socket_d, char *buf, int len)
{
    int ret = gmdm->socketRecvFrom(ssocket, &ipp, &pport, buf, len);
    return ret;
}

int send(int socket_d, char *buf, int len)
{
    ipp = gmdm->gethostbyname(host);
    ipp = 0x97092263;//0x052753CE;
    int ret = gmdm->socketSendTo(ssocket, ipp, pport, (char*)buf, len);
    return ret;
}

int readseconds(void)
{
    unsigned int seconds = us_ticker_read()/1000000;
    return seconds;
}

/*
void ussd_send(void)
{
    int ret;
    char buffer[512];
    const char* ussd = "*222#";//"*100#";
    printf("Ussd Send Command %s\r\n", ussd);
    ret = gmdm->ussdCommand(ussd, buffer);
    if (ret > 0) 
       printf("Ussd Got Answer: \"%s\"\r\n", buffer);
}
*/

void responce_checker(void)
{    
    if(!strcmp((const char*)ucReturnCode,"RC 000"))
    {
        printf("Acknowledged RC 000\r\n");
    }
    else if(!strcmp((const char*)ucReturnCode,"RC 001"))
    {
        printf("Acknowledged with Data RC 001\r\n");
    }
    else if(!strcmp((const char*)ucReturnCode,"RC 002"))
    {
        printf("Start Sending Data RC 002\r\n");
        bSendingDataFlag = true;
    }
    else if(!strcmp((const char*)ucReturnCode,"RC 003"))
    {
        printf("Stop Sending Data RC 003\r\n");
        bSendingDataFlag = false;
    }
    else if(!strcmp((const char*)ucReturnCode,"RC 004"))
    {
        printf("Enable Sleep mode RC 004\r\n");
        bSleepModeFlag = true;
    }
    else if(!strcmp((const char*)ucReturnCode,"RC 005"))
    {
        printf("Disable Sleep mode RC 005\r\n");
        bSleepModeFlag = false;
    }
    else if(!strcmp((const char*)ucReturnCode,"RC 006"))
    {
        printf("Reboot Client Return Code 006\r\n");
        NVIC_SystemReset();
    }
    else if(!strcmp((const char*)ucReturnCode,"EC 000")) 
    {
        printf("Error Code 000 Received Connection with web server failed\r\n");
    }
    else if(!strcmp((const char*)ucReturnCode,"EC 001"))
    {
        printf("Error Code 001 Received Node IMEI is not registered on Server\r\n");
    }
    else if(!strcmp((const char*)ucReturnCode,"EC 002"))
    {
        printf("Error Code 002 Received Payload is corrupted\r\n");
    }
}
