#include "mbed.h"
#include "DS1820.h"
#include "DHT.h"
#include "TSL2561_I2C.h"
#include "Adafruit_TCS34725.h"
#include "WakeUp.h"
#define commonAnode true


Serial wisol(D1, D0); // tx, rx

//debug
Serial pc(USBTX, USBRX);

//tempAir et humAir
DHT dht(D9, 22);


//RGB + luminosite
I2C i2c(PB_7, PB_6);
Adafruit_TCS34725 tcs = Adafruit_TCS34725(&i2c, TCS34725_INTEGRATIONTIME_50MS, TCS34725_GAIN_4X);

//tempSol 
DS1820 temp_sol(A4);

//humSol
AnalogIn   ain(A3);

int main(){
    
    //WakeUp::calibrate();   
    
        
    //DHT22
    int data;
    float tempAir, humAir;
    
    //humiditeSol
    int hum_sol;
    
    //luminosite
    float lux;
    
    //temp_sol
    if(temp_sol.unassignedProbe(A4))
    {
        pc.printf("error temperature_sol");
    }
    
    //capteur RGB/luminosite
    if(!tcs.begin())
    {
        pc.printf("No TCS34725 found ... check your connections");
    }
    
    while(1){
        //Capteur air
        data = dht.readData();
        humAir = dht.ReadHumidity();
        tempAir = dht.ReadTemperature(CELCIUS);
        pc.printf("tempAir = %1.f, humAir = %1.f\n", tempAir, humAir);
        
        
        //capteur humidite sol
        hum_sol = (int)(((0.78 - ain.read())*100)/0.38);
        pc.printf ("humSol =  %d%\n", hum_sol);
         
        //Capteur temperature sol
        temp_sol.convertTemperature(true, DS1820::all_devices);
        pc.printf("tempSol : %.1f\n", temp_sol.temperature());
        
        
        
        ///////////////
        //////RGB//////
        ///////////////
        
        uint16_t clear, red, green, blue;
        tcs.setInterrupt(false);      // turn on LED
        tcs.getRawData(&red, &green, &blue, &clear);
        tcs.setInterrupt(true);  // turn off LED
        //pc.printf("clear = %d, red = %d, green = %d, blue = %d\r\n", clear, red, green, blue);
        
        //get hexa value
        uint32_t sum = clear;
        float r, g, b;
        r = red; r /= sum;
        g = green; g /= sum;
        b = blue; b /= sum;
        r *= 256; g *= 256; b *= 256;
        pc.printf("clear = %d, red = %d, green = %d, blue = %d\r\n\n", clear, (int)r, (int)g, (int)b);
        
        
        
        
        //luminosite
        lux = (int)tcs.calculateLux(red,green,blue);
        pc.printf("lux = %d\n", (int)lux);
        
        
        wisol.printf("AT$SF=%06X%02X%02X%02X%04X%02X%04X%02X\r\n", (int)lux, (int)r, (int)g, (int)b, (int)(10 * temp_sol.temperature()), (int)(hum_sol), (int)(10 * tempAir), (int)(humAir));
                
        
        //lux : 3 octets
        //r, g, b : 1 octet
        //tempSol, tempAir : 2 octets
        //humSol, humAir : 1 octet
        
        wait(10);
        
        //Set wakeup time for 600 seconds = 10min
        WakeUp::set_ms(600000);
        deepsleep();
        wait(1);
        
    }
}