#ifndef DMU_H
#define DMU_H


#include "mbed.h"
/** 
 * A DMU interface for communicating with the Silicon Sensing DMU02 Dynamics Measurement Unit
 *
 */
class DMU {
public:
 
 
    /** Creates a DMU interface for using regular mbed pins
     *
     * @param MOSI        SPI MOSI line
     * @param MISO        SPI MISO line
     * @param SCLK         SPI SCLK line
     * @param S0-S2        Select lines for X, Y and Z axi
     *
     */
    DMU(PinName MOSI, PinName MISO, PinName SCLK, PinName S0, PinName S1, PinName S2); 
 
 
    /** Return the acceleration in the direction of the selected axis
     *
     * @param axis  The axis you wish to query: x, y or z.
     */
    float acceleration(char axis);
 
 
    /** Return the roll
     *
     */
    float  roll();    
    
    
    /** Return the pitch
     *
     */
    float  pitch(); 
 
    /** Return the yaw
     *
     */
    float yaw();


    /** forces the device to perform the built-in test
     *
     */    
    void test();
 
 
protected:

    //Device Initialization
    void _init();
    
    //used to set selected axis for query, active low
    void _selectAxis(char axis);
    
    //deselects all axis, inactive high
    void _deselectAxis();
    
    //writes control byte to device, populates data bytes, returns bool of if data was received correctly
    bool _write(char controlByte);
    
    bool _correctChecksumReceived(char statusByte, char chkSum);
    
      
// Regular mbed pins to drive chip, a SPI bus and S0-S2 which function as slave selects, active low
    SPI *_spi;
    BusOut *_cs;
    
// Received data bytes    
    char data0;
    char data1;
    char data2;
    char data3;

    
    // Timer used to ensure only 10 Hz total reads
    Timer _repClock;       
};

#endif