#include "DMU.h"

DMU::DMU(PinName MOSI, PinName MISO, PinName SCLK, 
         PinName S0,   PinName S1,   PinName S2){
    _spi = new SPI(MOSI, MISO, SCLK);               //communication
    _cs = new BusOut(S0, S1, S2);                   //slave select/axis selct
                                               
    _init();
    
    
} 

float DMU::acceleration(char axis){

    
    bool correctRead;
    do{
        _selectAxis(axis);
        correctRead = _write(0x01);
    }while (!correctRead);
    
    short dispA = (data2<<8) | data3;
    int negTester = 0x8000;
    if (negTester & dispA) dispA = -1 * (65536 - dispA);
    
    return dispA * .00366;

}

float DMU::roll(){

    bool correctRead;
    do{
        _selectAxis('x');
        correctRead = _write(0x01);
    }while (!correctRead);
    
    short dispA = (data0<<8) | data1;
    int negTester = 0x8000;
    if (negTester & dispA) dispA = -1 * (65536 - dispA);
    
    return dispA * .03125;

}
float DMU::pitch(){

    bool correctRead;
    do{
        _selectAxis('y');
        correctRead = _write(0x01);
    }while (!correctRead);
    
    short dispA = (data0<<8) | data1;
    int negTester = 0x8000;
    if (negTester & dispA) dispA = -1 * (65536 - dispA);
    
    return dispA * .03125;

}
float DMU::yaw(){

    bool correctRead;
    do{
        _selectAxis('z');
        correctRead = _write(0x01);
    }while (!correctRead);
    
    short dispA = (data0<<8) | data1;
    int negTester = 0x8000;
    if (negTester & dispA) dispA = -1 * (65536 - dispA);
    
    return dispA * .03125;

}

void DMU::test(){

    bool correctRead;
    do{
        _selectAxis('z');
        correctRead = _write(0x05);
    }while (!correctRead);
    
    do{
        _selectAxis('y');
        correctRead = _write(0x05);
    }while (!correctRead);
    
    do{
        _selectAxis('x');
        correctRead = _write(0x05);
    }while (!correctRead);

}

 
 
/*  Init the DMU
 *  
 *  
 */
void DMU::_init() {
    _repClock.start();              // start clock to allow first call of select axis to read from clock
    _spi->frequency(1150000);       // f = 1.15MHz, max f = 1.25MHz, min f = 4kHz
    _spi->format(8,0);              // 8 bits of data, CPOL = 0, CPHA = 0
  
}

void DMU::_selectAxis(char axis) {
    while (_repClock.read_ms() < 100);  //check to ensure device isn't read more than once every 100 ms
    _repClock.stop();
    _repClock.reset();
    switch (axis){
        case 'x':
            _repClock.start();
            _cs->write(6);              //drive SS to set x line low
            break;
        case 'y':
            _repClock.start();
            _cs->write(3);              //drive SS to set y line low
            break;
        case 'z':
            _repClock.start();
            _cs->write(5);              //drive SS to set z line low
    }
    wait(.000010);                      // wait time needed for device setup
}
 
void DMU::_deselectAxis() {

    _cs->write(7);

}

bool DMU::_write(char controlByte) {

    char status = _spi->write(controlByte);
    wait(.0000015);
    
    data0 = _spi->write(0x00);
    wait(.0000015);                             //min wait time between successive bytes is 1.1us
    
    data1 = _spi->write(0x00);
    wait(.0000015);
    
    data2 = _spi->write(0x00);
    wait(.0000015);
    
    data3 = _spi->write(0x00);
    wait(.0000015);

    char rCS = _spi->write(~controlByte);
    _deselectAxis();                            //deselect chip to ensure message duration is under 270 us
    
    
    return _correctChecksumReceived(status, rCS);



}

bool DMU::_correctChecksumReceived(char statusByte, char chkSum){

    char calculatedChecksum = statusByte + data0 + data1 + data2 + data3;
    
    if ((char)~chkSum != calculatedChecksum) return 0;
    return 1;

}