// Voltimetro DC con STM32
//Carlos Ramírez Quiroga
//3.02.2020
//Utiliza divisor de voltaje para obtener valores a ser medidos
#include "mbed.h"
#include "TextLCD.h" // Incluye la libreria para LCD
#define DEFAULT        0//no
#define ADAFRUIT       0//no
#define DFROBOT        0
#define LCM1602        0
#define YWROBOT        0
#define GYLCD          0//no
#define MJKDZ          0//no
#define SYDZ           1
#define WIDEHK         0//no
#define LCDPLUG        0//no

//TextLCD lcd(PC_8, PC_9, PD_3, PD_6, PD_11, PD_12, TextLCD::LCD 16x2); //Inicilizar la pantalla LCD sin controlador(se considera una pantalla de 16 caracteres X 2 Filas
AnalogIn   ain(PB_0);// Inicializar pin PB_0 como entrada análoga
Serial device(PA_2,PA_3,115200);
I2C i2c_lcd(PB_9, PB_8); // SDA, SCL (Configuración de LCD con controlador)
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4);

double vin=0.0;//voltaje de entrada a ser medido
double vout=0.0; //voltaje en entrada análoga
float R1=1000000;// 1 Mohms
float R2=100000;//100 Kohms
float value=0;

void setup()
{
    lcd.setBacklight(TextLCD::LightOn); // Retroiluminación de pantalla
    lcd.setCursor(TextLCD::CurOff_BlkOn);//Seteo cursor
    lcd.setUDC(0, (char *) udc_0);
    lcd.putc(0);
    lcd.setUDC(1, (char *) udc_1);
    lcd.putc(1);
    lcd.cls();//limpia pantalla
    int col = 0;//definición columna
    int row = 0;//definición fila
    lcd.locate(col,row);//Ubiación del cursor
    lcd.printf("Inicializando...");// mensaje de Inicialización de pantalla
    wait(2);//Espere 2 segundos
    //Secuencia de Incilización
    row++;
    lcd.locate(col,row);
    lcd.printf("Inicializando...");
    wait(2);
    row++;
    lcd.locate(col,row);
    lcd.printf("Inicializando...");
    wait(2);
    row++;
    lcd.locate(col,row);
    lcd.printf("Inicializando...");
}
void mostrar(double vin)
{
    lcd.setBacklight(TextLCD::LightOn);
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Voltaje de Entrada:");
    lcd.locate(0, 1);
    lcd.printf("%2.2f", vin);
}
int main()
{
    setup();
    while (1) {
        value=ain; //Lectura de entrada analoga escogida para divisor de voltaje
        device.printf ("ain V=%2.2f\r\n",value);//Lectura entrada análoga puerto serial
        vout=(value*3.0);//formula para convertir el valor de ADC a voltios
        device.printf ("vout V=%2.2f\r\n",vout);//Lectura entrada análoga puerto serial
        vin=vout/(R2/(R1+R2));//formula del voltaje de entrada a ser leído
        device.printf ("vin V=%2.2f\r\n",vin);//Lectura entrada análoga puerto serial
        if(ain<0.09) {
            vin=0.0;//si el voltaje leído en ain es menor a 0.09 Vcc setee en 0 el valor de Vin; esto representa 0,1V de Vin solo se presentará valores mayores a este
            device.printf ("vin\r\n");
        }
        mostrar(vin);
        wait(0.5);//espere 0,5 segundos
    }
}

