/*Portet from arduino


 * File name  : HP20x_dev.h
 * Description: Driver for I2C PRECISION BAROMETER AND ALTIMETER [HP206C]
 * Author     : Oliver Wang from Seeed studio
 * Version    : V0.1
 * Create Time: 2014/04
 * Change Log :
*/
#ifndef _HP20X_DEV_H
#define _HP20X_DEV_H
/****************************************************************************/
/***        Including Files                                               ***/
/****************************************************************************/

#include "mbed.h"
/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/


#define HP20X_ADDRESS          0xEC
//#define HP20X_I2C_DEV_ID       (0xEC)>>1    //CSB PIN is VDD level(address is 0x76)
//#define HP20X_I2C_DEV_ID2      (0XEE)>>1    //CSB PIN is GND level(address is 0x77)
#define HP20X_SOFT_RST         0x06 //Soft reset the device
#define HP20X_WR_CONVERT_CMD   0x40
#define HP20X_CONVERT_OSR4096  0<<2
#define HP20X_CONVERT_OSR2048  1<<2
#define HP20X_CONVERT_OSR1024  2<<2
#define HP20X_CONVERT_OSR512   3<<2
#define HP20X_CONVERT_OSR256   4<<2
#define HP20X_CONVERT_OSR128   5<<2

#define HP20X_READ_P           0x30   //Read the pressure value only
#define HP20X_READ_A           0x31   //Read the altitude value only
#define HP20X_READ_T           0x32   //Read the temperature value only
#define HP20X_READ_PT          0x10   //Read the temperature and pressure values
#define HP20X_READ_AT          0x11   //Read the temperature and altitude values
#define HP20X_READ_CAL         0X28   //Re-calibrate the internal analog blocks

#define HP20X_WR_REG_MODE      0xC0
#define HP20X_RD_REG_MODE      0x80

#define ERR_WR_DEVID_NACK       0x01    
#define ERR_RD_DEVID_NACK       0x02    
#define ERR_WR_REGADD_NACK      0x04   
#define ERR_WR_REGCMD_NACK      0x08   
#define ERR_WR_DATA_NACK        0x10     
#define ERR_RD_DATA_MISMATCH    0x20 

#define I2C_DID_WR_MASK         0xFE
#define I2C_DID_RD_MASK         0x01

#define T_WIN_EN                0X01
#define PA_WIN_EN               0X02
#define T_TRAV_EN               0X04
#define PA_TRAV_EN              0X08
#define PA_RDY_EN               0X20
#define T_RDY_EN                0X10

#define T_WIN_CFG               0X01
#define PA_WIN_CFG              0X02
#define PA_MODE_P               0X00
#define PA_MODE_A               0X40

#define T_TRAV_CFG              0X04

#define OK_HP20X_DEV            0X80        //HP20x_dev successfully initialized
#define REG_PARA                0X0F        //Status register

/****************************************************************************/
/***        Class Definitions                                             ***/
/****************************************************************************/
class HP20x_dev
{
  /* Public variables and functions */
  public:
  
  HP20x_dev(PinName p_sda, PinName p_scl);
  
    char OSR_CFG;
    int  OSR_ConvertTime;
    /* Constructor */ 
    void reset();
    char isAvailable();
    
    /* Read sensor data */
    //long ReadTemperature(void);
    long ReadPressure(void);
   // long ReadAltitude(void);
   protected:
    I2C i2c;
    void writeByte(uint8_t address, uint8_t subAddress, uint8_t data);
    char readByte(uint8_t address, uint8_t subAddress);
   
    
  
};
//extern HP20x_dev HP20x;
#endif