/* Quick and dirty program to receive keystrokes and send text via virtual
 * serial port, it also flashes the green led with 1 millisecond pulses as
 * life indicator
 *
 * Unfortunally the mbed lib sends an error via serial when PwmOut is used
 *
 * This program has been derived from
 * https://os.mbed.com/users/Bongjun/code/LPC11U68_USBSerial/
 *
 */

#include "mbed.h"

DigitalOut LED_rd(LED1);
DigitalOut LED_gn(LED2);
DigitalOut LED_bl(LED3);
/*
// PwmOut: mbed lib raises an error: no available SCT, even LED pins provide PWM
    PwmOut LED_rd(LED1);
    PwmOut LED_gn(LED2);
    PwmOut LED_bl(LED3);
    float brightness_LED_rd = 0.8;
    float brightness_LED_gn = 0.4;
    float brightness_LED_bl = 0.2;
*/

//Virtual serial port over USB
Serial pc(USBTX, USBRX);

volatile uint8_t    buf[] = {'\0', '\0'};   // buf[1]: string null terminator

void onCharReceived()   // fills character buffer using rx interrupt
{
    buf[0] = pc.getc();
}

int main()
{
    LED_rd = LED_gn = LED_bl = 1;           // LEDs off
    pc.baud(115200);                        // from default = 9600
    pc.attach(&onCharReceived);
    pc.printf("\r\n\n\n#####  LPCXpresso11U68_USBSerial  #####\r\n\r\nPress any key at the PC keyboard!\r\n\r\n");

    while(1) {
//uint32_t            counter = 0;            // Debug only
//        pc.printf("%8d\r\n", counter++);    // Debug only

        switch(buf[0])
        {
            case '\0':
                break;
            case 'a':
                pc.printf("recv char IS THE EXPECTED 'a' = 0x%.2x\r\n", buf[0]);
                break;
            case 'b':
                pc.printf("recv char IS THE EXPECTED 'b' = 0x%.2x\r\n", buf[0]);
                break;
            default:
                pc.printf("recv char is not expected: ");
                if (buf[0]<33)
                    pc.printf("0x%.2x\r\n", buf[0]); // hex code, when non-printable char
                else
                    pc.printf("%s\r\n", buf);
                break;
        }
        buf[0] = '\0';      // reset character buffer

        LED_gn = 0; wait_ms(1);     // just one millisecond due to high brightness of green
        LED_gn = 1; wait_ms(299);
    }
}
