#include "mbed.h"
#include "C12832.h"
#include "Sht31.h"
#include <string>
#include "time.h"
#include "mbed_trace.h"
#include "mbed_events.h"
#include "LoRaWANInterface.h"
#include "SX1276_LoRaRadio.h"

// Device credentials, register device as OTAA in The Things Network and copy credentials here
static uint8_t DEV_EUI[] = { 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18 };
static uint8_t APP_EUI[] = { 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18 };
static uint8_t APP_KEY[] = { 0xE3, 0x5D, 0xED, 0xC4, 0x1F, 0xA6, 0xAC, 0xAC, 0xE6, 0x88, 0xD8, 0x28, 0xF0, 0x38, 0x1D, 0x37 };

// The port we're sending and receiving on
#define MBED_CONF_LORA_APP_PORT     15

// Peripherals (LoRa radio, temperature sensor and button)
SX1276_LoRaRadio radio(D11, D12, D13, D10, A0, D2, D3, D4, D5, D8, D9, NC, NC, NC, NC, A4, NC, NC);
Sht31 sht31(I2C_SDA, I2C_SCL);
//InterruptIn btn(BUTTON1);

C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11);
DigitalOut ledWhite(p5);
DigitalOut ledRed(p7);
DigitalOut ledYellow(p11);
InterruptIn btn(p9);
InterruptIn switchs(p12);

Ticker call;
Ticker ticker;
Ticker ticker2;
Ticker ticker3;
Timeout callEnd;
Timeout resetEnd;

bool direction = true;
bool readingTime = true;
time_t startSecond;
time_t endSecond;
time_t startReading;
time_t endReading;
time_t reset;

int readingDuration = 0;
int scrollingMode=0;
int currentTopics=0;
int indexs;
int scrolling=1;
int forwardIndex;
int state = 0;
int readingState = 0;

// EventQueue is required to dispatch events around
static EventQueue ev_queue;

// Constructing Mbed LoRaWANInterface and passing it down the radio object.
static LoRaWANInterface lorawan(radio);

// Application specific callbacks
static lorawan_app_callbacks_t callbacks;

// LoRaWAN stack event handler
static void lora_event_handler(lorawan_event_t event);

string topics[]={"Topic 1. Available crops",
"Topic 2. Infrastructure",
"Topic 3. Population density"};
string content[]={"In Musanze district, the main crops grown are the following: Potatoes, Beans, Pyrethrum, Oignon, Carrot.",
"Different infrastructure found in Musanze districts are the following: Roads, Schools, Hospitals, Hotels, Electricity, Water, Telecomunication infrastructure.",
"Baby Care Movement"};

void displayTopic(string text){
    lcd.cls();
    lcd.locate(0,10);
    lcd.printf(text.c_str());
}

void blinkingWhiteLed(){
    ledWhite = !ledWhite;
}

void displayContent(){
    state = 1;
    ticker.detach();
    time(&startReading);
    displayTopic(content[currentTopics]);
}

void scrollingFowd(){
    ledYellow = 1;
    ledRed = 0;
    currentTopics=indexs;
    displayTopic(topics[indexs].c_str());
    indexs++;
    if(indexs > 2){
        indexs = 0;
    }
}

void scrollingBack(){
    ledYellow = 0;
    ledRed = 1;
    currentTopics=indexs;
    displayTopic(topics[indexs]);
    indexs--;
    if(indexs < 0){
        indexs = 2;
    }
}

void scrollingTopic(){
    if(direction){
        indexs = 0;
        ticker.attach(ev_queue.event(&scrollingFowd),2.0f);
    }else{
        indexs = 2;
        ticker.attach(ev_queue.event(&scrollingBack),2.0f);
    }
}

void displayTemp(){
    float temp = sht31.readTemperature();
    lcd.locate(1, 18);
    lcd.printf("Temp: %.2f C", temp);
}

void currentTime(){
    lcd.cls();
    call.attach(ev_queue.event(&blinkingWhiteLed), 1.0f);// 1.0f is floot number 
    struct tm t;// get the current time from the terminal
    set_time(mktime(&t));// set the time
    time_t seconds = time(NULL);
    lcd.locate(1,0);
    lcd.printf("The time:%s \n",ctime(&seconds));
}


void mode1(){
    currentTime();
    displayTemp();
    callEnd.attach(ev_queue.event(&scrollingTopic),3.0f);
}

void welcome(){
    lcd.cls();
    int i;
    lcd.set_auto_up(0);
    for (i = -20; i < 5; i++) { // scrolling text
        lcd.locate(5, i);
        lcd.printf("Welcome Group 3");
        lcd.locate(5, i + 12);
        lcd.printf("Best service company Ltd");
        lcd.copy_to_lcd();
        lcd.locate(5, i);
        wait(0.2);
        lcd.printf("Welcome Group 3");
        lcd.locate(5, i + 12);
        lcd.printf("Best service company Ltd");
        lcd.copy_to_lcd();
        i = i + 1;
        
    }
    callEnd.attach(ev_queue.event(&mode1),5.0f);
}

void btnFall(){
    state = 0;
    ticker2.detach();
}



void calculateDuration(){
     time(&endSecond);
     int d = endSecond - startSecond;
     printf("Duration %d\n", d);
     if(d >= 5){
         direction = !direction;
         displayTopic("The system Reset \n");
         ticker.detach();
         ticker2.detach();
         callEnd.attach(ev_queue.event(&welcome),10.0f);
         //resetEnd.attach(callback(&mode1),15.0f);
     }
     else if(d >= 3 && state == 0){
         state=1;
         direction = !direction;
         ticker.detach();
         scrollingTopic();
     }
}

void btnRise(){
    time(&startSecond);
    ticker2.attach(ev_queue.event(&calculateDuration), 0.5f);
}

static uint8_t* create_message(char device[], int topic1, int duration1) {
     // initialize the buffer
     uint8_t tx_buffer[50] = { 0 };
     
     // DATA TO SEND (THE BELOW VALUES ARE THE ONES TO BE MODIFIED)
     // char device[] = "infant";
     //int topic = 3; // topic identifier
     //long int start = 1606037871;  // start reading
     //long int end =   1606038090; // end reading
     
    //int duration = 20;
     
     // Writing string data into a buffer
     sprintf((char*) tx_buffer, "{\"device\":\"%s\",\"topic\":%d,\"duration\":%d }", device, topic1,duration1);
     return tx_buffer;
}


// Send a message over LoRaWAN
static void send_message(uint8_t *tx_buffer) {
   
    int packet_len = strlen((char*) tx_buffer);

    printf("Sending %d bytes: \"%s\"\n", packet_len, tx_buffer);


    int16_t retcode = lorawan.send(MBED_CONF_LORA_APP_PORT, tx_buffer, packet_len, MSG_UNCONFIRMED_FLAG);

    // for some reason send() returns -1... I cannot find out why, the stack returns the right number. I feel that this is some weird Emscripten quirk
    if (retcode < 0) {
        retcode == LORAWAN_STATUS_WOULD_BLOCK ? printf("send - duty cycle violation\n")
                : printf("send() - Error code %d\n", retcode);
        return;
    }

    printf("%d bytes scheduled for transmission\n", retcode);
}


void switchFall(){
    time(&endReading);//press swetch end time
    int r = endReading - startReading;
    printf("Reading time %d\n", r);
    if(r >= 5){
        printf("Topic sent %d \n", (currentTopics+1));//+1 will give you the exact topic ID
        char device[] = "infant";
        int topicss = currentTopics+1; // topic identifier
        send_message(create_message(device, topicss, r));
    }
    state = 0;
    scrollingTopic();
}


int main() {
    lcd.locate(24,10);
    lcd.printf("Keep waiting . . .  \n");
    
    if (DEV_EUI[0] == 0x0 && DEV_EUI[1] == 0x0 && DEV_EUI[2] == 0x0 && DEV_EUI[3] == 0x0 && DEV_EUI[4] == 0x0 && DEV_EUI[5] == 0x0 && DEV_EUI[6] == 0x0 && DEV_EUI[7] == 0x0) {
        printf("Set your LoRaWAN credentials first!\n");
        return -1;
    }

    printf("Press BUTTON1 to send the current value of the temperature sensor!\n");

    // Enable trace output for this demo, so we can see what the LoRaWAN stack does
    mbed_trace_init();

    if (lorawan.initialize(&ev_queue) != LORAWAN_STATUS_OK) {
        printf("LoRa initialization failed!\n");
        return -1;
    }

    // Fire a message when the button is pressed
    //btn.fall(ev_queue.event(&send_data_button_isr));
    
    btn.rise(ev_queue.event(&btnRise));
    switchs.rise(ev_queue.event(&displayContent));
    switchs.fall(ev_queue.event(&switchFall));
    btn.fall(ev_queue.event(&btnFall));

    // prepare application callbacks
    callbacks.events = mbed::callback(lora_event_handler);
    lorawan.add_app_callbacks(&callbacks);

    // Disable adaptive data rating
    if (lorawan.disable_adaptive_datarate() != LORAWAN_STATUS_OK) {
        printf("disable_adaptive_datarate failed!\n");
        return -1;
    }

    lorawan.set_datarate(5); // SF7BW125

    lorawan_connect_t connect_params;
    connect_params.connect_type = LORAWAN_CONNECTION_OTAA;
    connect_params.connection_u.otaa.dev_eui = DEV_EUI;
    connect_params.connection_u.otaa.app_eui = APP_EUI;
    connect_params.connection_u.otaa.app_key = APP_KEY;
    connect_params.connection_u.otaa.nb_trials = 3;

    lorawan_status_t retcode = lorawan.connect(connect_params);

    if (retcode == LORAWAN_STATUS_OK ||
        retcode == LORAWAN_STATUS_CONNECT_IN_PROGRESS) {
    } else {
        printf("Connection error, code = %d\n", retcode);
        return -1;
    }

    printf("Connection - In Progress ...\r\n");

    // make your event queue dispatching events forever
    ev_queue.dispatch_forever();

    return 0;
}

// This is called from RX_DONE, so whenever a message came in
static void receive_message()
{
    uint8_t rx_buffer[50] = { 0 };
    int16_t retcode;
    retcode = lorawan.receive(MBED_CONF_LORA_APP_PORT, rx_buffer,
                              sizeof(rx_buffer),
                              MSG_CONFIRMED_FLAG|MSG_UNCONFIRMED_FLAG);

    if (retcode < 0) {
        printf("receive() - Error code %d\n", retcode);
        return;
    }

    printf("Data received on port %d (length %d): ", MBED_CONF_LORA_APP_PORT, retcode);

    for (uint8_t i = 0; i < retcode; i++) {
        printf("%02x ", rx_buffer[i]);
    }
    printf("\n");
}

// Event handler
static void lora_event_handler(lorawan_event_t event) {
    switch (event) {
        case CONNECTED:
            printf("Connection - Successful\n");
            welcome();
            break;
        case DISCONNECTED:
            ev_queue.break_dispatch();
            printf("Disconnected Successfully\n");
            break;
        case TX_DONE:
            printf("Message Sent to Network Server\n");
            break;
        case TX_TIMEOUT:
        case TX_ERROR:
        case TX_CRYPTO_ERROR:
        case TX_SCHEDULING_ERROR:
            printf("Transmission Error - EventCode = %d\n", event);
            break;
        case RX_DONE:
            printf("Received message from Network Server\n");
            receive_message();
            break;
        case RX_TIMEOUT:
        case RX_ERROR:
            printf("Error in reception - Code = %d\n", event);
            break;
        case JOIN_FAILURE:
            printf("OTAA Failed - Check Keys\n");
            break;
        default:
            MBED_ASSERT("Unknown Event");
    }
}