#include "operator_stack.h"
#include <stdlib.h>

/* operator stack functions */
char operator_stack_get(operator_stack_node* beginning)
{
  if (beginning)
    return beginning->data;
  else
    return 0;
}

char operator_stack_pop(operator_stack_node* beginning)
{
  if (beginning)
  {
     operator_stack_node* aux;
     aux = beginning;
    
    if (beginning->next)
        beginning = beginning->next;
    else 
        beginning = NULL;
     
     char c = aux->data;
     free(aux);
     return c;
  }
  else
    return 0;
}

void operator_stack_push(operator_stack_node* beginning, char a_data)
{
  operator_stack_node* new_node;
  new_node = (operator_stack_node*) malloc(sizeof(operator_stack_node));
  
  new_node->data = a_data;
  new_node->next = beginning;
  beginning = new_node;
}