#include "mbed.h"
#include "DS3231.h"
#include "_24LCXXX.h"

Serial pc(USBTX, USBRX);

int hour;
int minute;
int second;

int dayOfWeek;
int date;
int month;
int year;
int data2;

I2C i2c(PB_9, PB_8);            // sda, scl
_24LCXXX eeprom(&i2c, 0x57);
DS3231 rtc(PB_9,PB_8);

bool EN32kHz()
    {int reg=rtc.readRegister(DS3231_Control_Status);
    return(reg&DS3231_bit_EN32kHz);
    }


int main()
{

    pc.printf("rtc online\n");

    pc.printf("\r\n\nDS3231 Library test program\r\nremi cormier 2012\r\n\n");

    //rtc.setI2Cfrequency(400000); //hi speed support

    //rtc.eraseOSF();

    //rtc.writeRegister(DS3231_Aging_Offset,0); // uncomment to set Aging Offset 1LSB = approx. 0.1 ppm according from datasheet = 0.05 ppm @ 21 °C from my measurments

    //rtc.convertTemperature();//////////

    int reg=rtc.readRegister(DS3231_Aging_Offset);
    if (reg>127) {
        reg=reg-256;
    }
    pc.printf("Aging offset : %i\r\n",reg);
    
        int regc=rtc.readRegister(DS3231_Control);

    pc.printf("DS3231_Control : %i\r\n",regc);
    
    

    pc.printf("EN32kHz : %i\r\n",EN32kHz());

    pc.printf("OSF flag : %i",rtc.OSF());
    pc.printf("\r\n");

    rtc.readDate(&date,&month,&year);
    pc.printf("date : %02i-%02i-%02i",date,month,year);
    pc.printf("\r\n");

    //rtc.setTime(19,26,00); // uncomment to set time

    rtc.readTime(&hour,&minute,&second);
    pc.printf("time : %02i:%02i:%02i",hour,minute,second);
    pc.printf("\r\n");

    //rtc.setDate(3,10,12,2014); // uncomment to set date6,22,12,2012

    rtc.readDateTime(&dayOfWeek,&date,&month,&year,&hour,&minute,&second);
    pc.printf("date time : %i / %02i-%02i-%02i %02i:%02i:%02i",dayOfWeek,date,month,year,hour,minute,second);
    pc.printf("\r\n");

    pc.printf("temperature :%6.2f",rtc.readTemp());
    pc.printf("\r\n");

//    pc.printf("memory int data write!\n");
//    data2 = 100;
//    eeprom.nbyte_write( 0, &data2, sizeof(int));
//    pc.printf("\nend\n");
//    
//    pc.printf("memory int data read!\n");
//    eeprom.nbyte_read( 1, &data2, sizeof(uint8_t) );
//    pc.printf("int:%d sizeofint:%d",data2, sizeof(uint8_t));
//    pc.printf("\nend\n");

}