#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include <cstdlib>
#include <iostream>




Serial pc(USBTX, USBRX);

TSISensor tsi;
MMA8451Q acc51(PTE25, PTE24, 0x1D<<1);
MAG3110 mag(PTE25, PTE24, 0x0E<<1);

PwmOut rled(PTE29);
PwmOut gled(PTD5);
AnalogIn lightSensor(PTE22);
InterruptIn s1(PTC3);
InterruptIn s3(PTC12);

int base_rate=100;
int A=1, M=1, T=1, L=1, gE=1;;
int aH=base_rate, mH = base_rate, tH = base_rate, lH = base_rate;
Timer t;
int counter; 

    
int main()
{
    using namespace std;
    int count_acc = 1, count_mag = 1, count_light = 1, count_touch = 1, available = 0;
//    int extra_light =0, extra_touch =0, extra_mag =0, extra_acc =0;
    
    int magX = 0, magY = 0, magZ = 0;
    mag.getValues(&magX, &magY, &magZ);
 
    float holdTime = 5.0;
   // acc.attach(&Acc, 0.010);
//    mag.attach(&Mag, 0.010);
//    light.attach(&Light, 0.010);
   
    t.start();
    while(1) {
        mag.getValues(&magX, &magY, &magZ);
        counter = t.read_ms();
        if(A == 1 && counter%(aH+1) == aH)
            cout << "A" << "X" << acc51.getAccX() << "Y" << acc51.getAccY() << "Z"<< acc51.getAccZ() << "\n"  ;
        if(M == 1 && counter%(mH+1) == mH)
           cout << "M" << mag.getHeading() << "X" << magX << "Y" << magY << "Z" << magZ << "\n";
        if(L == 1 && counter%(lH+1) == lH)
            cout << "L" << lightSensor << "\n";
        if(T == 1 && counter%(tH+1) == tH)
            cout << "T" << tsi.readPercentage() << "\n" ;
//        cout <<"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n\r";    
        //if( count_acc != 0 || count_mag != 0 || count_light != 0 || count_touch != 0){
//                available = 1;
//                extra_acc = count_acc;       
//                extra_mag = count_mag;
//                extra_light = count_light;
//                extra_touch = count_touch;
//        }
//            
//        while( available == 1){
//            if (A == 1 && extra_acc > 0){
//                extra_acc--;
//                cout << "A" << "X" << acc51.getAccX() << "Y" << acc51.getAccY() << "Z"<< acc51.getAccZ() << "\n\r"  ;
//            }  
//            if (M == 1 && extra_mag > 0){
//                extra_mag--;
//                cout << "M" << magMeter.getHeading() << "X" << magX << "Y" << magY << "Z" << magZ << "\n\r";
//            } 
//            if (T == 1 && extra_touch > 0){
//                extra_touch--;
//                cout << "T" << tsi.readPercentage() << "\n\r" ;
//                
//            } 
//            if (L == 1 && extra_light > 0){
//                extra_light--;
//                cout << "L" << lightSensor << "\n\r";
//            } 
//            if( extra_acc == 0 && extra_mag == 0 && extra_touch == 0 && extra_light == 0)
//                available = 0;
//            
//        }

         if (pc.readable()){//
//            NVIC_DisableIRQ(TIMER3_IRQn);
             if(pc.getc() == 'i'){
                pc.printf("\n#######################################\n");
                pc.printf("Entered Sensor configuration Mode\n");
                pc.printf("#######################################\n");
                pc.printf("Present Active Sensors\n");
                if(A == 1) pc.printf("Acccelerometer\n");
                if(M == 1) pc.printf("Magnetometer\n");
                if(T == 1) pc.printf("Touchglider\n");
                if(L == 1) pc.printf("LightSensor\n");
                pc.printf("#######################################\n");
                pc.printf("Enable / Disable Sensors? (0/1)\n");
                pc.printf("Acccelerometer - (0/1)\n");
                count_acc = (int) pc.getc();
                (count_acc != '0')? A = 1: A=0;
                if ( A==1 ){
                    pc.printf("Acccelerometer - Enabled !\n Enter the rate (Three digit number)\n");
                    aH=0;
                    pc.printf("  You entered - ");
                    for(int k=1; k<=3;k++){
                        aH =   aH * 10 +  pc.getc() - 48;
                        pc.printf("%d",aH%10);
                    }
                    pc.printf("\n");
                    aH = 1000 / aH;
//                    aH =  count_acc;
//                    count_acc == 1 ? count_acc = 0: count_acc-=1;
                }
                else 
                    pc.printf("Acccelerometer - Disabled !\n");
                pc.printf("Magnetometer - (0/1)? \n");
                  count_mag = (int) pc.getc();
                (count_mag != '0')? M = 1: M=0;
                if ( M==1 ){
                    pc.printf("Magnetometer - Enabled !\n Enter the rate (Three digit number)\n");
                    mH=0;
                    pc.printf("  You entered - ");
                    for(int k=1; k<=3;k++){
                        mH =   mH * 10 +  pc.getc() - 48;
                        pc.printf("%d",mH%10);
                    } 
                    pc.printf("\n");
                    mH = 1000/mH;
//                    cout << "MH = " << mH << "\n\r";
//                    mH = base_rate/ count_mag;
                  
//                    count_mag == 1 ? count_mag = 0: count_mag-=1;    
                }
                else
                    pc.printf("Magnetometer - Disabled !\n");
                pc.printf("Touchglider - (0/1)? \n");
                 count_touch = (int) pc.getc();
                (count_touch != '0')? T = 1: T=0;
                if ( T==1 ){
                    pc.printf("Touchglider - Enabled !\n Enter the rate (Three digit number)\n");
                    tH=0;
                    pc.printf("  You entered - ");
                    for(int k=1; k<=3;k++){
                        tH =   tH * 10 + pc.getc() - 48;
                        pc.printf("%d",tH%10);
                    } 
                    pc.printf("\n");
                    tH = 1000 / tH;
//                   tH = base_rate/ count_touch ;
//                    count_touch == 1 ? count_touch = 0: count_touch-=1;    
                }
                else 
                    pc.printf("Touchglider - Disabled !\n");
                pc.printf("LightSensor - (0/1)? \n");
                count_light = (int) pc.getc();
                (count_light != '0')? L = 1: L=0;
                if ( L==1 ){
                    pc.printf("LightSensor - Enabled !\n Enter the rate (Three digit number)\n");
                    lH=0;
                    pc.printf("  You entered - ");
                    for(int k=1; k<=3;k++){
                        lH =   lH * 10 + pc.getc() - 48;
                        pc.printf("%d",lH%10);
                    }
                    pc.printf("\n");
                    lH = 1000 / lH;
//                    pc.printf("LH = %d",lH);
//                    count_light == 1 ? count_light = 0: count_light-=1;    
                }
                else
                    pc.printf("LightSensor - Disabled !\n");
             }
        }
    }
}
