#include "mbed.h"
#include "DHT.h"
 
DigitalOut myled(LED1);
Serial pc(USBTX,USBRX);
DHT sensor(p22,DHT11); // Use the SEN11301P sensor
 
int main() {
    int err;
    pc.printf("\r\nDHT Test program");
    pc.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    while (1) {
        myled = 1;
        err = sensor.readData();
        if (err == 0) {
            pc.printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            pc.printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            pc.printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            pc.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
            pc.printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            pc.printf("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
        } else
            pc.printf("\r\nErr %i \n",err);
        myled = 0;
        wait(100);
    }
}