
    #include "mbed.h"
#include "PCF8591.h"


/** Create a PCF8591 AD and DA object using a specified I2C bus and slaveaddress
  *
  * @param I2C &i2c the I2C port to connect to 
  * @param char deviceAddress the address of the PCF8591
  */  
PCF8591::PCF8591(I2C *i2c) : _i2c(i2c) {
    
  _slaveAddress = PCF8591_ADDR;

}


uint8_t PCF8591::ADC_read(uint8_t channel) {

char cmd;
    char anaval;
    cmd=channel;
    _i2c->write( _slaveAddress, &cmd, 1 );
    _i2c->read( _slaveAddress, &anaval, 1 );
    return anaval;

};
