#include "hardware_timer3.h"
#include "gpio.h"
#include "stm32f4xx_rcc_mort.h"
#include "interrupt.h"

/*Below are defined all Timers and flags required */ //COPYING ALL VALUES AND DEFINITIONS FROM HARDWARE_TIMER3.C
#define TIM3_BASE_ADDRESS ((uint32_t)0x40000400)
#define TIM3_STATUS_REGISTER (TIM3_BASE_ADDRESS + 0x10)
#define TIM3_PSC_REGISTER (TIM3_BASE_ADDRESS + 0x28)
#define TIM3_AUTORELOAD_REGISTER (TIM3_BASE_ADDRESS + 0x2C)
#define TIM3_COUNTER_REGISTER (TIM3_BASE_ADDRESS + 0x24)
#define TIM3_CAPTURE_COMPARE_MODE_2_REGISTER (TIM3_BASE_ADDRESS + 0x1C)
#define TIM_CCMR13_OC1M_0 (0b00010000)
#define TIM_CCMR13_OC1M_1 (0b00100000)
#define TIM_CCMR13_OC1M_2 (0b01000000)
#define TIM_CCMR13_OCPE (0b00001000)
#define TIM_CCMR23_
#define TIM_CCMR13_OUTPUT 0x00
#define TIM3_COMPARE3_REGISTER (TIM3_BASE_ADDRESS + 0x3C)
#define TIM3_CAPTURE_COMPARE_ENABLE_REGISTER (TIM3_BASE_ADDRESS + 0x20)
#define TIM3_CR1_REGISTER1 (TIM3_BASE_ADDRESS + 0x00)
#define TIM3_CAPTURE_COMPARE_MODE_1_REGISTER (TIM3_BASE_ADDRESS + 0x18)
#define TIM3_CAPTURE_COMPARE_REGISTER_1 (TIM3_BASE_ADDRESS + 0x34)

#define TIM3_CCMR2_CC3S_OUTPUT (0b11111100)
#define TIM3_CCMR2_OC3FE (0b11111011)
#define TIM3_CCMR2_OC3PE (0b00001000)
#define TIM3_CCMR2_OC3M1 (0b11101111)
#define TIM3_CCMR2_OC3M2 (0b01100000)

# define TIM3_INTERRUPT_ENABLE_REGISTER (TIM3_BASE_ADDRESS + 0x0C)

/* MACRO definitions----------------------------------------------------------*/
#define SYSTEM_CONTROL_BASE_ADDRESS (0xE000E000)
#define NVIC_BASE_ADDRESS (SYSTEM_CONTROL_BASE_ADDRESS + 0x100)
#define NVIC_INTERRUPT_SET_ENABLE_REGISTER_0_31 (NVIC_BASE_ADDRESS)
#define NVIC_INTERRUPT_SET_ENABLE_REGISTER_32_63 (NVIC_BASE_ADDRESS+0x4)
#define NVIC_INTERRUPT_SET_ENABLE_REGISTER_64_95 (NVIC_BASE_ADDRESS+0x8)
#define TIM3_INTERRUPT_BIT (0x20000000)

#define NVIC_INTERRUPT_CLEAR_ENABLE_REGISTER_0_31 (NVIC_BASE_ADDRESS + 0x80)
#define NVIC_INTERRUPT_CLEAR_ENABLE_REGISTER_32_63 (NVIC_INTERRUPT_CLEAR_ENABLE_REGISTER_0_31 + 0x4)
#define NVIC_INTERRUPT_CLEAR_ENABLE_REGISTER_64_95 (NVIC_INTERRUPT_CLEAR_ENABLE_REGISTER_0_31 + 0x8)
#define NVIC_INTERRUPT_SET_PENDING_REGISTER_0_31 (NVIC_BASE_ADDRESS + 0x100)
#define NVIC_INTERRUPT_SET_PENDING_REGISTER_32_63 (NVIC_INTERRUPT_SET_PENDING_REGISTER_0_31 + 0x4)
#define NVIC_INTERRUPT_SET_PENDING_REGISTER_64_95 (NVIC_INTERRUPT_SET_PENDING_REGISTER_0_31 + 0x8)
#define NVIC_INTERRUPT_CLEAR_PENDING_REGISTER_0_31 (NVIC_BASE_ADDRESS + 0x180)
#define NVIC_INTERRUPT_CLEAR_PENDING_REGISTER_32_63 (NVIC_INTERRUPT_CLEAR_PENDING_REGISTER_0_31 + 0x4)
#define NVIC_INTERRUPT_CLEAR_PENDING_REGISTER_64_95 (NVIC_INTERRUPT_CLEAR_PENDING_REGISTER_0_31 + 0x8)
#define EXTI9_5_INTERRUPT_BIT (0x800000)

//For external interrupts:
#define SYSCFG_BASE_ADDRESS ((uint32_t)(0x40013800))
#define SYSCFG_EXTERNAL_INTERRUPT_REGISTER_2 (SYSCFG_BASE_ADDRESS + 0x0C)
#define SYSCFG_EXTERNAL_INTERRUPT_6_BITS ((uint32_t)0xF00) //flags for External interrupt register 2
#define SYSCFG_EXTERNAL_INTERRUPT_6_PORTC ((uint32_t)0x200) 
//External interrupt controller :
#define EXTERNAL_INTERRUPT_CONTROLLER_BASE_ADDRESS ((uint32_t)(0x40013C00))
#define EXTERNAL_INTERRUPT_CONTROLLER_MASK_REGISTER (EXTERNAL_INTERRUPT_CONTROLLER_BASE_ADDRESS)
#define EXTERNAL_INTERRUPT_CONTROLLER_MASK_REGISTER_EXTI6 ((uint32_t)0x40) //flags for external interrupt controller mask register
#define EXTERNAL_INTERRUPT_CONTROLLER_RTSR (EXTERNAL_INTERRUPT_CONTROLLER_BASE_ADDRESS+0x08)
#define EXTERNAL_INTERRUPT_CONTROLLER_RTSR_EXTI6 ((uint32_t)0x40)
#define EXTERNAL_INTERRUPT_CONTROLLER_FTSR (EXTERNAL_INTERRUPT_CONTROLLER_BASE_ADDRESS+0x0C)
#define EXTERNAL_INTERRUPT_CONTROLLER_FTSR_EXTI6 ((uint32_t)0x40)
#define EXTERNAL_INTERRUPT_CONTROLLER_PENDING_REGISTER (EXTERNAL_INTERRUPT_CONTROLLER_BASE_ADDRESS+0x14)
#define EXTERNAL_INTERRUPT_CONTROLLER_PENDING_EXTI6 ((uint32_t)0x40)


void enableNVIC_Timer3(void)
{
    uint32_t * reg;
    reg = (uint32_t *)NVIC_INTERRUPT_SET_ENABLE_REGISTER_0_31;
    *reg = TIM3_INTERRUPT_BIT; 
}

void TIM3_IRQHandler(void)
{
    uint16_t * reg_pointer_16_sr;
    uint16_t * reg_pointer_16_dier;
    reg_pointer_16_sr = (uint16_t *)TIM3_STATUS_REGISTER;
    reg_pointer_16_dier = (uint16_t *)TIM3_INTERRUPT_ENABLE_REGISTER;
 //check which interrupts fired and if they were supposed to fire, then clear the flags so they don’t keep firing,
// then perform actions according to these interrupts
//check if Output Compare 3 triggered the interrupt:
    if (( (*reg_pointer_16_sr & 0x8) >0) && ( (*reg_pointer_16_dier & 0x8) >0))
    {
 //clear interrupt
    *reg_pointer_16_sr = ~((uint16_t)0x8);
 //perform action
    clearGPIOB0(); 
     }
//check if Overflow triggered the interrupt: I.e. Timer Counter 3 >= Autorreload value
    if (( (*reg_pointer_16_sr & 0x01) >0) && ( (*reg_pointer_16_dier & 0x1) >0))
    {
 //clear interrupt
    *reg_pointer_16_sr = ~((uint16_t)0x01);
 //perform action
    setGPIOB0();
    } 
}

void enableEXTI6OnPortC(void)
{
    uint32_t * reg;
 /*Init GPIO 6 C as input*/
    initGpioC6AsInput();
 /*As a test, Init GPIO B0 as output for debugging*/
    InitPortBPin0asOutput();
 /* Enable SYSCFG clock */
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_SYSCFG, ENABLE);
 /*map EXTI6 to port C bit 6*/
    reg = (uint32_t *)SYSCFG_EXTERNAL_INTERRUPT_REGISTER_2;
 //clear EXTI6
    *reg = *reg & ~SYSCFG_EXTERNAL_INTERRUPT_6_BITS;
 //set EXTI6 to Port C
    *reg = *reg | SYSCFG_EXTERNAL_INTERRUPT_6_PORTC; 
 /*un-mask EXTI6*/
    reg = (uint32_t *)EXTERNAL_INTERRUPT_CONTROLLER_MASK_REGISTER;
    *reg = *reg | EXTERNAL_INTERRUPT_CONTROLLER_MASK_REGISTER_EXTI6;
 /*trigger on rising edge*/
    reg = (uint32_t *)EXTERNAL_INTERRUPT_CONTROLLER_RTSR;
    *reg = *reg | EXTERNAL_INTERRUPT_CONTROLLER_RTSR_EXTI6;
 /* set the NVIC to respond to EXTI9_5*/
    reg = (uint32_t *)NVIC_INTERRUPT_SET_ENABLE_REGISTER_0_31;
    *reg = EXTI9_5_INTERRUPT_BIT; 
}

void EXTI9_5_IRQHandler(void)
{
    uint32_t * reg;
    reg = (uint32_t *)EXTERNAL_INTERRUPT_CONTROLLER_PENDING_REGISTER;
 //check which interrupt fired:
    if ((*reg & EXTERNAL_INTERRUPT_CONTROLLER_PENDING_EXTI6)>0)
 {
 //clear the interrupt:
    *reg = EXTERNAL_INTERRUPT_CONTROLLER_PENDING_EXTI6;
 //toggle the LED
    toggleGPIOB0();
 }
}

