#include "gpio.h"
#include "main_Lec9.h"
#include "stm32f4xx_rcc_mort.h"


/* Below are defined Address of Port B and corresponding registers*/
#define PORTB_BASE_ADDRESS ((uint32_t)0x40020400)
#define PORTB_MODER_REGISTER (PORTB_BASE_ADDRESS + 0x00)
#define PORTB_OTYPER_REGISTER (PORTB_BASE_ADDRESS + 0x04)
#define PORTB_OSPEEDR_REGISTER (PORTB_BASE_ADDRESS + 0x08)
#define PORTB_PUPDR_REGISTER (PORTB_BASE_ADDRESS + 0x0C)
#define PORTB_IDR_REGISTER (PORTB_BASE_ADDRESS + 0x10)
#define PORTB_ODR_REGISTER (PORTB_BASE_ADDRESS + 0x14)
#define PORTB_AFR1_REGISTER (PORTB_BASE_ADDRESS + 0x20)

/* Below are defined Address of Port C and corresponding registers*/
#define PORTC_BASE_ADDRESS ((uint32_t)0x40020800)
#define PORTC_MODER_REGISTER (PORTC_BASE_ADDRESS + 0x00)
#define PORTC_OTYPER_REGISTER (PORTC_BASE_ADDRESS + 0x04)
#define PORTC_OSPEEDR_REGISTER (PORTC_BASE_ADDRESS + 0x08)
#define PORTC_PUPDR_REGISTER (PORTC_BASE_ADDRESS + 0x0C)
#define PORTC_IDR_REGISTER (PORTC_BASE_ADDRESS + 0x10)
#define PORTC_ODR_REGISTER (PORTC_BASE_ADDRESS + 0x14)
#define PORTC_AFR1_REGISTER (PORTC_BASE_ADDRESS + 0x20)

void InitPortBPin0asOutput(void)
{
    uint32_t *reg; /*Define Pointer*/
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE); /* Enable the clock */
    
    reg = (uint32_t *)PORTB_MODER_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); /*Clear last two bits of Moder Register*/
    *reg = *reg | ((uint32_t)0x01); /* Set the last two pins corresponding to Pin0 as Output Mode - 01 */
    
    reg = (uint32_t *)PORTB_OTYPER_REGISTER;
    *reg = *reg & (~((uint32_t)0x01)); /* Clear the last bit of OTYPER REGISTER*/
    *reg = *reg | ((uint32_t)0x00);/*Statement is to set the OTYPER REGISTER TO 0 - Push Pull Type*/
    
    reg = (uint32_t *)PORTB_PUPDR_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); /* Clear the last two bits of PUPDR REGISTER*/
    *reg = *reg | ((uint32_t)0x00);/*Statement is to set the PUPDR REGISTER TO 00 - No Pull Up No Pull Down Type*/
    
    //reg=(uint32_t *)PORTB_OSPEEDR_REGISTER;
    //*reg=*reg&(~((uint32_t)0x11)); /* Clear the last two bits of OSPEEDR REGISTER*/
    //*reg=*reg|((uint32_t)0x11); /* Set the last two bits of OSPEEDR REGISTER to High Speed*/
    
    reg = (uint32_t *)PORTB_ODR_REGISTER;
    *reg = *reg | ((uint32_t)0x01); /* Setting the ODR REGISTER TO HIGH TO START WITH - Last bit is 1*/
}



void toggleGPIOB0(void)
{
    uint32_t value;
    uint32_t *reg; /* Defining the variables*/
    
    reg = (uint32_t *)PORTB_ODR_REGISTER; /*Initializing the current value of ODR REGISTER*/
    value = *reg & ((uint32_t)0x1); /* Reading the value of last bit of current ODR REGISTER - Stored in reg*/
    
    if (value > 0)
    {
        /* The bit is high initially*/
        /*Need to set it to low now*/
        *reg = *reg & (~((uint32_t)0x1));
    }
    
    else
    {
        /* The bit is low initially*/
        /* Need to set it to high now*/
        *reg = *reg | ((uint32_t)0x01);
    }
}




void InitGPIOBPin0asOutputCompare(void)
{
    uint32_t *reg; //Initialize register pointer variable
    
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE); /* Enable the clock */
    
    reg = (uint32_t *)PORTB_MODER_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); //Clear last two bits of MODER REGISTER
    *reg = *reg | ((uint32_t)0b10); //Write 10 to last two bits of MODER REGISTER
    
    reg = (uint32_t *)PORTB_OTYPER_REGISTER;
    *reg = *reg & (~((uint32_t)0x01)); //Clear last bit of OTYPER REGISTER
    *reg = *reg | ((uint32_t)0x00); //Setting 0 to last bit of OTYPER REGISTER
    
    reg = (uint32_t *)PORTB_PUPDR_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); //Clear last two bits of PUPDR REGISTER - NO PULL UP/DOWN
    
    //reg = (uint32_t *)PORTB_OSPEEDR_REGISTER;
    //*reg = *reg & (~((uint32_t)0x03)); //Clear last two bits of OSPEEDR REGISTER
    //*reg = *reg | ((uint32_t)0x03); //Setting of 11 to last two bits of OSPEEDR REGISTER - HIGH SPEED
    
    reg = (uint32_t *)PORTB_AFR1_REGISTER;
    *reg = *reg & (~((uint32_t)0xF)); //Clear last four bits of AFRL0 - GPIOB_AFRL REGISTER
    *reg=*reg|((uint32_t)0x2); //Set last four digits of AFRL0 to 0010 - AF2 Alternate Function
}



void InitGPIOCPin6asInputCapture(void)
{
    uint32_t *reg; //Initialize register pointer variable
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOC, ENABLE); /* Enable the clock */
    
    reg = (uint32_t *)PORTC_MODER_REGISTER;
    *reg = *reg & (~((uint32_t)0x3000)); //Clear last two bits of MODER REGISTER
    *reg = *reg | ((uint32_t)0x2000); //Write 10 to last two bits of MODER REGISTER
    
    reg = (uint32_t *)PORTC_OTYPER_REGISTER;
    *reg = *reg & (~((uint32_t)0x40)); //Clear last bit of OTYPER REGISTER
    *reg = *reg | ((uint32_t)0x00); //Setting 0 to last bit of OTYPER REGISTER
    
    reg = (uint32_t *)PORTC_OSPEEDR_REGISTER;
    *reg = *reg & (~((uint32_t)0x3000)); //Clear last two bits of OSPEEDR REGISTER
    *reg = *reg | ((uint32_t)0x3000); //Setting of 11 to last two bits of OSPEEDR REGISTER - HIGH SPEED
    
    reg = (uint32_t *)PORTC_PUPDR_REGISTER;
    *reg = *reg & (~((uint32_t)0x3000)); //Clear last two bits of PUPDR REGISTER - NO PULL UP/DOWN
    *reg = *reg | 0x00; //Setting two bits of PUPDR REGISTER - NO PULL UP/DOWN
    
    reg = (uint32_t *)PORTC_AFR1_REGISTER;
    *reg= *reg & (~((uint32_t)0xF000000)); //Clear last four bits of AFRL0 - GPIOB_AFRL REGISTER
    *reg= *reg | ((uint32_t)0x2000000); //Set last four digits of AFRL0 to 0010 - AF2 Alternate Function
}

void InitGPIOBPin0asPWMMode1(void)
{
    uint32_t *reg; //Initialize register pointer variable
    
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE); /* Enable the clock */
    
    reg = (uint32_t *)PORTB_MODER_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); //Clear last two bits of MODER REGISTER
    *reg = *reg | ((uint32_t)0b10); //Write 10 to last two bits of MODER REGISTER
    
    reg = (uint32_t *)PORTB_OTYPER_REGISTER;
    *reg = *reg & (~((uint32_t)0x01)); //Clear last bit of OTYPER REGISTER
    *reg = *reg | ((uint32_t)0x00); //Setting 0 to last bit of OTYPER REGISTER
    
    reg = (uint32_t *)PORTB_PUPDR_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); //Clear last two bits of PUPDR REGISTER - NO PULL UP/DOWN
    
    reg = (uint32_t *)PORTB_OSPEEDR_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); //Clear last two bits of OSPEEDR REGISTER
    *reg = *reg | ((uint32_t)0x03); //Setting of 11 to last two bits of OSPEEDR REGISTER - HIGH SPEED
    
    reg = (uint32_t *)PORTB_AFR1_REGISTER;
    *reg = *reg & (~((uint32_t)0xF)); //Clear last four bits of AFRL0 - GPIOB_AFRL REGISTER
    *reg=*reg|((uint32_t)0x2); //Set last four digits of AFRL0 to 0010 - AF2 Alternate Function
}

void setGPIOB0( void )
{
    uint32_t * reg;
    reg = (uint32_t *)PORTB_ODR_REGISTER;
    *reg = *reg | 0b01; 
}

void clearGPIOB0( void )
{
    uint32_t * reg;
    reg = (uint32_t *)PORTB_ODR_REGISTER;
    *reg = *reg & (~(uint32_t)0b01); 
}

void initGpioC6AsInput( void )
{
    uint32_t * reg; 
 /* GPIOC Peripheral clock enable */
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOC, ENABLE);
 /* GPIOC Pin 6 as input*/
    reg = (uint32_t *)PORTC_MODER_REGISTER;
    *reg = *reg & (~((uint32_t)0x3000));
    *reg= *reg | 0x0000;
 /*PUSH-PULL Pin*/
    reg = (uint32_t *)PORTC_OTYPER_REGISTER;
    *reg = *reg & (~((uint32_t)0x40));
    *reg = *reg | 0x00;
 /*GPIOC pin 6 high speed */
    reg = (uint32_t *)PORTC_OSPEEDR_REGISTER;
    *reg= *reg| 0x3000;
 /*Configure pulled-down*/
    reg = (uint32_t *)PORTC_PUPDR_REGISTER;
    *reg = *reg & (~((uint32_t)0x3000));
    *reg= *reg | 0x2000;
}

