#include "gpio.h"
#include "hardware_dma_controller.h"
#include "stm32f4xx_rcc_mort.h"
#include "hardware_adc.h"

//Defining Base Addresses and Registers
#define DMA2_BASE_ADDRESS               ((uint32_t)0x40026400)
#define DMA2_LISR_REGISTER              (DMA2_BASE_ADDRESS + 0x00)
#define DMA2_HISR_REGISTER              (DMA2_BASE_ADDRESS + 0x04)
#define DMA2_LIFCR_REGISTER             (DMA2_BASE_ADDRESS + 0x08)
#define DMA2_HIFCR_REGISTER             (DMA2_BASE_ADDRESS + 0x0C)
#define DMA2_S0CR_REGISTER              (DMA2_BASE_ADDRESS + 0x10)
#define DMA2_S0NDTR_REGISTER            (DMA2_BASE_ADDRESS + 0x14)
#define DMA2_S0PAR_REGISTER             (DMA2_BASE_ADDRESS + 0x18)
#define DMA2_S0M0AR_REGISTER            (DMA2_BASE_ADDRESS + 0x1C)
#define DMA2_S0M1AR_REGISTER            (DMA2_BASE_ADDRESS + 0x20)
#define DMA2_S0FCR_REGISTER             (DMA2_BASE_ADDRESS + 0x24)

//Defining bits and flags
//DMA_SxCR: DMA STREAM X CONFIGURATION REGISTER
#define DMA_SxCR_CHANNEL_2_SELECT       (((uint32_t)2)<<25) //To Select Channel 2
#define DMA_SxCR_MSIZE_HALF_WORD        (((uint32_t)1)<<13) //The location memory is 16 bits in length
#define DMA_SxCR_PSIZE_HALF_WORD        (((uint32_t)1)<<11) //The peripheral data size is 16 bits in length
#define DMA_SxCR_MINC_INCREMENT         (((uint32_t)1)<<10) //Increment the place where you store the data each transfer
#define DMA_SxCR_CIRC_ENABLE            (((uint32_t)1)<<8) //Enable circular mode
#define DMA_SxCR_DIR_PERTOMEM           0
#define DMA_SxCR_STREAM_ENABLE          1


#define ADC_REGISTER_BASE_ADDRESS   ((uint32_t)0x40012000)
#define ADC_3_BASE_ADDRESS          (ADC_REGISTER_BASE_ADDRESS + 0x200)
#define ADC_3_DR_REGISTER           (ADC_3_BASE_ADDRESS + 0x4C)


uint16_t adcDmaDataStorageBuffer_3_Channel[3]; //Variable Definition to store read values
uint16_t adcDmaDataStorageBuffer_1_Channel[1]; //Variable Definition to store read value


//FUNCTION GIVEN BY PROFESSOR TO SETUP DMA TO READ VALUES FROM 3 PINS
void initDMAForAdc3_1Channel(void)
{
    uint32_t * reg;
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_DMA2, ENABLE); /* Enable the clock */
    
    // Configure Stream 0 to use Channel 2 - ADC3
    reg = (uint32_t *)DMA2_S0CR_REGISTER;
    *reg = DMA_SxCR_CHANNEL_2_SELECT + DMA_SxCR_MSIZE_HALF_WORD + DMA_SxCR_PSIZE_HALF_WORD + DMA_SxCR_DIR_PERTOMEM +DMA_SxCR_CIRC_ENABLE;
    
    //We will transfer 1 data registers for 1 channels of ADC
    reg = (uint32_t *)DMA2_S0NDTR_REGISTER;
    *reg = 1;
    
    //We will transfer from the ADC3 Data Register
    reg = (uint32_t *)DMA2_S0PAR_REGISTER;
    *reg = ADC_3_DR_REGISTER; //THIS FUNCTION IS DEFINED IN HARDWARE ADC
    
    //We will transfer to the adcDmaDataStorageBuffer we created
    reg = (uint32_t *)DMA2_S0M0AR_REGISTER;
    *reg = (uint32_t)&adcDmaDataStorageBuffer_1_Channel[0]; //QUESTION - WHY IS THIS ZERO??? DIDNT UNDERSTAND THIS STATEMENT
    
}



//FUNCTION GIVEN BY PROFESSOR TO SETUP DMA TO READ VALUES FROM 3 PINS
void initDMAForAdc3_3Channels(void)
{
    uint32_t * reg;
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_DMA2, ENABLE); /* Enable the clock */
    
    // Configure Stream 0 to use Channel 2 (ADC3)
    reg = (uint32_t *)DMA2_S0CR_REGISTER;
    *reg = DMA_SxCR_CHANNEL_2_SELECT + DMA_SxCR_MSIZE_HALF_WORD + DMA_SxCR_PSIZE_HALF_WORD + DMA_SxCR_MINC_INCREMENT + DMA_SxCR_DIR_PERTOMEM +DMA_SxCR_CIRC_ENABLE;
    
    //We will transfer 3 data registers for 3 channels of ADC
    reg = (uint32_t *)DMA2_S0NDTR_REGISTER;
    *reg = 3;
    
    //We will transfer from the ADC3 Data Register
    reg = (uint32_t *)DMA2_S0PAR_REGISTER;
    *reg = ADC_3_DR_REGISTER; //THIS FUNCTION IS DETECTED
    
    //We will transfer to the adcDmaDataStorageBuffer we just created
    reg = (uint32_t *)DMA2_S0M0AR_REGISTER;
    *reg = (uint32_t)& adcDmaDataStorageBuffer_3_Channel[0];
    
}


void enableDMAForAdc3_3channels (void)
{
    uint32_t * reg;
    reg = (uint32_t *)DMA2_S0CR_REGISTER;
    *reg = *reg | DMA_SxCR_STREAM_ENABLE;
}

void enableDMAForAdc3_1channels (void)
{
    uint32_t * reg;
    reg = (uint32_t *)DMA2_S0CR_REGISTER;
    *reg = *reg | DMA_SxCR_STREAM_ENABLE;
}



uint16_t returnADC3StoredValue3Channel(uint8_t index)
{
    return adcDmaDataStorageBuffer_3_Channel[index];
}
    
    
uint16_t returnADC3StoredValue1Channel(uint8_t index)
{
    return adcDmaDataStorageBuffer_1_Channel[index];
}
    
     
     

