#include "gpio.h"
#include "hardware_adc.h"
#include "stm32f4xx_rcc_mort.h"
#include "hardware_dma_controller.h"

//DEFINITION OF BASE ADDRESS FOR ADC1-ADC2-ADC3
#define ADC_REGISTER_BASE_ADDRESS ((uint32_t)0x40012000)

//DEFINITION OF BASE ADDRESS AND REGISTER ADDRESSES FOR ADC1
#define ADC_1_BASE_ADDRESS          (ADC_REGISTER_BASE_ADDRESS + 0x000)
#define ADC_1_SR_REGISTER           (ADC_1_BASE_ADDRESS + 0x00)
#define ADC_1_CR1_REGISTER          (ADC_1_BASE_ADDRESS + 0x04)
#define ADC_1_CR2_REGISTER          (ADC_1_BASE_ADDRESS + 0x08)
#define ADC_1_SMPR1_REGISTER        (ADC_1_BASE_ADDRESS + 0x0C)
#define ADC_1_SMPR2_REGISTER        (ADC_1_BASE_ADDRESS + 0x10)
#define ADC_1_SQR1_REGISTER         (ADC_1_BASE_ADDRESS + 0x2C)
#define ADC_1_SQR2_REGISTER         (ADC_1_BASE_ADDRESS + 0x30)
#define ADC_1_SQR3_REGISTER         (ADC_1_BASE_ADDRESS + 0x34)
#define ADC_1_DR_REGISTER           (ADC_1_BASE_ADDRESS + 0x4C)

//DEFINITION OF BASE ADDRESS AND REGISTER ADDRESSES FOR ADC2
#define ADC_2_BASE_ADDRESS          (ADC_REGISTER_BASE_ADDRESS + 0x100)
#define ADC_2_SR_REGISTER           (ADC_2_BASE_ADDRESS + 0x00)
#define ADC_2_CR1_REGISTER          (ADC_2_BASE_ADDRESS + 0x04)
#define ADC_2_CR2_REGISTER          (ADC_2_BASE_ADDRESS + 0x08)
#define ADC_2_SMPR1_REGISTER        (ADC_2_BASE_ADDRESS + 0x0C)
#define ADC_2_SMPR2_REGISTER        (ADC_2_BASE_ADDRESS + 0x10)
#define ADC_2_SQR1_REGISTER         (ADC_2_BASE_ADDRESS + 0x2C)
#define ADC_2_SQR2_REGISTER         (ADC_2_BASE_ADDRESS + 0x30)
#define ADC_2_SQR3_REGISTER         (ADC_2_BASE_ADDRESS + 0x34)
#define ADC_2_DR_REGISTER           (ADC_2_BASE_ADDRESS + 0x4C)

//DEFINITION OF BASE ADDRESS AND REGISTER ADDRESSES FOR ADC3
#define ADC_3_BASE_ADDRESS          (ADC_REGISTER_BASE_ADDRESS + 0x200)
#define ADC_3_SR_REGISTER           (ADC_3_BASE_ADDRESS + 0x00)
#define ADC_3_CR1_REGISTER          (ADC_3_BASE_ADDRESS + 0x04)
#define ADC_3_CR2_REGISTER          (ADC_3_BASE_ADDRESS + 0x08)
#define ADC_3_SMPR1_REGISTER        (ADC_3_BASE_ADDRESS + 0x0C)
#define ADC_3_SMPR2_REGISTER        (ADC_3_BASE_ADDRESS + 0x10)
#define ADC_3_SQR1_REGISTER         (ADC_3_BASE_ADDRESS + 0x2C)
#define ADC_3_SQR2_REGISTER         (ADC_3_BASE_ADDRESS + 0x30)
#define ADC_3_SQR3_REGISTER         (ADC_3_BASE_ADDRESS + 0x34)
#define ADC_3_DR_REGISTER           (ADC_3_BASE_ADDRESS + 0x4C)

//DEFINITION OF BASE ADDRESS AND REGISTER ADDRESSES FOR COMMON REGISTERS
#define ADC_COMMON_REGISTERS        (ADC_REGISTER_BASE_ADDRESS + 0x300)
#define ADC_CSR_REGISTER            (ADC_COMMON_REGISTERS + 0x00)
#define ADC_CCR_REGISTER            (ADC_COMMON_REGISTERS + 0x04)



//FUNCTION DEFINED FOR - ADC 3 CONTINUOUS CONVERSION USING CHANNEL 5 
void initADC3_5_withDMA(void)
{
     uint32_t * reg;
     
     //Turn on ADC3 BUS CLOCKS
     RCC_APB2PeriphClockCmd(RCC_APB2Periph_ADC3, ENABLE); /* Enable the clock */
     
     //Initialize GPIO F 7 as Analog
     InitPortFPin7asAnalog();
     
     initDMAForAdc3_1Channel();              //FUNCTION IS DEFINED // CHECK FOR THIS FUNCTION IN MAIN
     enableDMAForAdc3_1channels();           //FUNCTION IS DEFINED
     
     //Writing Pre Scale Value divided by 4 - 01 in bits 17&16 of CCR Register
     reg = (uint32_t *)ADC_CCR_REGISTER;
     *reg = 0x10000; 
     
     //STATUS REGISTER IS CLEARED IN START CONVERSION FUNCTION
     
//     //Clear Status Register                    //QUESTION - IS THIS ACTION MANDATORY ??
//     reg = (uint32_t *)ADC_3_SR_REGISTER;
//     *reg = 0;
//        

     //Configure ADC 12BIT Resolution, END OF CONVERSION INTERRUPT DISABLED - EOCIE
     reg = (uint32_t *)ADC_3_CR1_REGISTER;
     *reg = 0; //Configure ADC 12BIT Resolution, END OF CONVERSION INTERRUPT DISABLED - EOCIE
     //*reg = *reg & (~((uint32_t)0x3000000)) & (~((uint32_t)0x20)); //DO YOU HAVE TO WRITE TO THIS REGISTER OR READ THE VALUE ???
     
     //Configure ADC External trigger disabled, right data alignment, DMA Enabled ,
     //EOC is set at the end of each regular conversion, continuous conversion enabled 
     reg = (uint32_t *)ADC_3_CR2_REGISTER;
     *reg = ((uint32_t)0x02) + ((uint32_t)0x100) + ((uint32_t)0x400);
     //*reg = ADC_E0CS + ADC_CONT + ADC_DDS + ADC_DMA;   //DO YOU HAVE TO WRITE TO THIS REGISTER OR READ THE VALUE ???
        
     //There will be 1 Channel (Channel 5) in the sequence of conversions - SQR1
     reg = (uint32_t *)ADC_3_SQR1_REGISTER;
     *reg = 0; //1 conversion is 0000
     
     //Configure Channels 5 to max sampling times (480 cycles)
     reg = (uint32_t *)ADC_3_SMPR2_REGISTER;
     *reg = 0x38000; //Writing 111 to bits 15,16&17
     
     //Configure the sequence of conversion for the ADC (7)
     reg = (uint32_t *)ADC_3_SQR3_REGISTER;
     * reg = 0x05; //WRITING 7 TO SQR1 (BITS 0 TO 4) IN SQR3 REGISTER
     
     enableADC3(); //ADDITIONAL LINE - IT ALREADY IS PRESENT IN START ADC CONVERSION
     
     //Start a software conversion
     //Need to do this separately
     
}



//FUNCTION DEFINED BY PROFESSOR - ADC 3 SCAN CONTINUOUS CONVERSION USING 3 CHANNELS
 void initADC3_567_withDMA(void)
 {
     uint32_t * reg;
     
     //Turn on ADC3 BUS CLOCKS
     RCC_APB2PeriphClockCmd(RCC_APB2Periph_ADC3, ENABLE); /* Enable the clock */
     
     //Initialize GPIO F 7 8 9 as Analog
     InitPortFPin7Pin8Pin9asAnalog();
     
     initDMAForAdc3_3Channels();             //FUNCTION IS DEFINED
     enableDMAForAdc3_3channels();           //FUNCTION IS DEFINED
     
     //I HAVE NOT CLEARED STATUS REGISTER - NO NEED - STATUS REGISTER IS CLEARED WHILE CALLING FUNCTION - START CONVERSION
     
     //Configure ADC 12BIT Resolution, END OF CONVERSION INTERRUPT DISABLED , SCAN MODE ENABLED 
     //TO BE ABLE TO SCAN A GROUP OF CHANNELS
     reg = (uint32_t *)ADC_3_CR1_REGISTER;
     //*reg = 0; //IS THIS STATEMENT MANDATORY TO SET 25TH and 24th BIT AS 00
     *reg = (uint32_t)0x100 ;  //THIS STATEMENT ALSO SETS 25TH and 24th BIT AS 00 but it does set the SCAN MODE ON
     
     //Configure ADC External trigger dissabled (29th and 28th Bit is set to 0), right data alignment (11th bit is 0), DMA ,
     //EOC is set at the end of each regular conversion, continuous conversion enabled 
     reg = (uint32_t *)ADC_3_CR2_REGISTER;
     *reg = (uint32_t)0x100 + (uint32_t)0x02 + (uint32_t)0x400; //Is the 10th bit supposed to be set to 0 - EC0 SET AT THE END OF EACH CONVERSION
     
     //There will be 3 channels in the sequence of conversions
     reg = (uint32_t *)ADC_3_SQR1_REGISTER;
     *reg = (uint32_t)0x200000; //0010 3 will be 2 actually
     
     //Configure Channels 5,6,7 to max sampling times (480 cycles)
     reg = (uint32_t *)ADC_3_SMPR2_REGISTER;
     *reg = (uint32_t)0x38000 + (uint32_t)0x1C0000 + (uint32_t)0xE00000; //In the order of 5th Channel set to 480 Cycles , 6th Channel set to 480 Cycles , 7th Channel set to 480 Cycles
     
     //Configure the sequence of conversion for the ADC (5,6,7)
     reg = (uint32_t *)ADC_3_SQR3_REGISTER;
     * reg = (uint32_t)0x05 + (uint32_t)0xC0 + (uint32_t)0x1C00; //In the order of SQ1 written to 5, SQ2 written to 6 . SQ3 writtent to 7
     
     enableADC3();
     
     //Start a software conversion
     //Need to do this separately
     
}
     

//FUNCTON TO TURN ON ADC3
void enableADC3(void)
{
     uint32_t * reg;
     reg = (uint32_t *)ADC_3_CR2_REGISTER;
     *reg= *reg | ((uint32_t)0x01);
}    


//FUNCTION TO START ADC CONVERSION
void startADCConversion(void)
{
     uint32_t * reg;
     
     reg = (uint32_t *)ADC_3_SR_REGISTER;
     *reg = 0;
     
     reg = (uint32_t *)ADC_3_CR2_REGISTER;
     *reg = *reg | 0x01;
}     