#include "gpio.h"
#include "main.h"
#include "stm32f4xx_rcc_mort.h"


/* Below are defined Address of Port F and corresponding registers*/
#define PORTF_BASE_ADDRESS ((uint32_t)0x40021400)
#define PORTF_MODER_REGISTER (PORTF_BASE_ADDRESS + 0x00)
#define PORTF_OTYPER_REGISTER (PORTF_BASE_ADDRESS + 0x04)
#define PORTF_OSPEEDR_REGISTER (PORTF_BASE_ADDRESS + 0x08)
#define PORTF_PUPDR_REGISTER (PORTF_BASE_ADDRESS + 0x0C)
#define PORTF_IDR_REGISTER (PORTF_BASE_ADDRESS + 0x10)
#define PORTF_ODR_REGISTER (PORTF_BASE_ADDRESS + 0x14)
#define PORTF_AFR1_REGISTER (PORTF_BASE_ADDRESS + 0x20)

/* Below are defined Address of Port B and corresponding registers*/
#define PORTB_BASE_ADDRESS              ((uint32_t)0x40020400)
#define PORTB_MODER_REGISTER            (PORTB_BASE_ADDRESS + 0x00)
#define PORTB_OTYPER_REGISTER           (PORTB_BASE_ADDRESS + 0x04)
#define PORTB_OSPEEDR_REGISTER          (PORTB_BASE_ADDRESS + 0x08)
#define PORTB_PUPDR_REGISTER            (PORTB_BASE_ADDRESS + 0x0C)
#define PORTB_IDR_REGISTER              (PORTB_BASE_ADDRESS + 0x10)
#define PORTB_ODR_REGISTER              (PORTB_BASE_ADDRESS + 0x14)
#define PORTB_AFR1_REGISTER             (PORTB_BASE_ADDRESS + 0x20)



void InitPortFPin7asAnalog(void)
{
    uint32_t *reg; /*Define Pointer*/
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOF, ENABLE); /* Enable the clock */
    
    reg = (uint32_t *)PORTF_MODER_REGISTER;
    *reg = *reg & (~((uint32_t)(0x03<<14))); /*Clear bits 14 & 15 of Moder Register*/
    *reg = *reg | (uint32_t)(0x03<<14); /* Set the bits 14 & 15 as 11 - Analog Output Mode */
    
    reg = (uint32_t *)PORTF_OTYPER_REGISTER;
    *reg = *reg & (~((uint32_t)(0x01<<7))); /* Statement is to set the OTYPER REGISTER of Pin 7 TO 0 - Push Pull Type */

    
    reg = (uint32_t *)PORTF_PUPDR_REGISTER;
    *reg = *reg & (~((uint32_t)(0x03<<14))); /* Statement is to set the PUPDR REGISTER TO 00 - No Pull Up No Pull Down Type*/

}

void InitPortFPin7Pin8Pin9asAnalog(void)
{
    uint32_t *reg; /*Define Pointer*/
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOF, ENABLE); /* Enable the clock */
    
    reg = (uint32_t *)PORTF_MODER_REGISTER;
    *reg = *reg & (~((uint32_t)(0x03<<14))+ (uint32_t)(0x03<<16) + (uint32_t)(0x03<<18)); /*Clear bits 14, 15, 16, 17, 18, 19 of Moder Register*/
    *reg = *reg | ((uint32_t)(0x03<<14) + (uint32_t)(0x03<<16) + (uint32_t)(0x03<<18)); /* Set the bits 14, 15, 16, 17, 18, 19 as 11 - Analog Output Mode */
    
    reg = (uint32_t *)PORTF_OTYPER_REGISTER;
    *reg = *reg & (~((uint32_t)(0x01<<7)+ (uint32_t)(0x01<<8) + (uint32_t)(0x01<<9))); /* Statement is to set the OTYPER REGISTER of Pin 7, 8, 9 TO 0 - Push Pull Type */

    
    reg = (uint32_t *)PORTF_PUPDR_REGISTER;
    *reg = *reg & (~((uint32_t)(0x03<<14)+ (uint32_t)(0x03<<16) + (uint32_t)(0x03<<18) )); /* Statement is to set the PUPDR REGISTER OF PIN 7,8,9 TO 00 - No Pull Up No Pull Down Type*/

}


void InitPortBPin0asOutput(void)
{
    uint32_t *reg; /*Define Pointer*/
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB, ENABLE); /* Enable the clock */
    
    reg = (uint32_t *)PORTB_MODER_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); /*Clear last two bits of Moder Register*/
    *reg = *reg | ((uint32_t)0x01); /* Set the last two pins corresponding to Pin0 as Output Mode - 01 */
    
    reg = (uint32_t *)PORTB_OTYPER_REGISTER;
    *reg = *reg & (~((uint32_t)0x01)); /* Clear the last bit of OTYPER REGISTER*/
    *reg = *reg | ((uint32_t)0x00);/*Statement is to set the OTYPER REGISTER TO 0 - Push Pull Type*/
    
    reg = (uint32_t *)PORTB_PUPDR_REGISTER;
    *reg = *reg & (~((uint32_t)0x03)); /* Clear the last two bits of PUPDR REGISTER*/
    *reg = *reg | ((uint32_t)0x00);/*Statement is to set the PUPDR REGISTER TO 00 - No Pull Up No Pull Down Type*/
    
    reg=(uint32_t *)PORTB_OSPEEDR_REGISTER;
    *reg=*reg&(~((uint32_t)0x11)); /* Clear the last two bits of OSPEEDR REGISTER*/
    *reg=*reg|((uint32_t)0x11); /* Set the last two bits of OSPEEDR REGISTER to High Speed*/
    
    reg = (uint32_t *)PORTB_ODR_REGISTER;
    *reg = *reg | ((uint32_t)0x01); /* Setting the ODR REGISTER TO HIGH TO START WITH - Last bit is 1*/
}



void toggleGPIOB0(void)
{
    uint32_t value;
    uint32_t *reg; /* Defining the variables*/
    
    reg = (uint32_t *)PORTB_ODR_REGISTER; /*Initializing the current value of ODR REGISTER*/
    value = *reg & ((uint32_t)0x1); /* Reading the value of last bit of current ODR REGISTER - Stored in reg*/
    
    if (value > 0)
    {
        /* The bit is high initially*/
        /*Need to set it to low now*/
        *reg = *reg & (~((uint32_t)0x1));
    }
    
    else
    {
        /* The bit is low initially*/
        /* Need to set it to high now*/
        *reg = *reg | ((uint32_t)0x01);
    }
}





