/*******************************************************************************
* Copyright (c) 2014 IBM Corporation and other Contributors.
*
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors: Sam Danbury
* IBM - Initial Contribution
*******************************************************************************/

#include "stdio.h"
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include "MMA7660.h"
#include "C12832_lcd.h"
#include "ExampleClient.h"
#include "cJSON.h"

#include <string>

using namespace std;

//LCD
C12832_LCD lcd;

//LED
DigitalOut led1(LED1);
DigitalOut led4(LED4);

//Accelerometer
MMA7660 MMA(p28, p27);

//Temperature sensor
LM75B tmp(p28, p27);

//Joystick
BusIn Down(p12);
BusIn Left(p13);
BusOut Click(p14);
BusIn Up(p15);
BusIn Right(p16);
string joystickPos;
void joystickThread(void const *args);
int getCount(char* message);

//Potentiometer
AnalogIn ain1(p19);
AnalogIn ain2(p20);
float pot1;
float pot2;
ExampleClient* c;
LocalFileSystem local("local");

int getdata(char* buf, int count)
{
    return (c->mysock).receive(buf, (size_t)count);
}

int main()
{
    char buf[250];
    int  buflen = sizeof(buf);
    //Connect to the network
    EthernetInterface eth;
    eth.init();
    eth.connect();
    
    //Obtain mac address of mbed
    string mac = eth.getMACAddress();
    
    //Remove colons from mac address
    mac.erase(remove(mac.begin(), mac.end(), ':'), mac.end());
    
    //Start thread to read data from joystick
    Thread jThd(joystickThread);
    joystickPos = "CENTRE";
    
    //ExampleClient* c = new ExampleClient(mac);
    c = new ExampleClient(mac);
    (c->mysock).set_blocking(true, 50000);
    int res = MQTTPacket_read(buf, buflen, getdata);
    if ( res == CONNACK)
    {
        int connack_rc;

        if (MQTTDeserialize_connack(&connack_rc, buf, buflen) != 1 || connack_rc != 0)
        {
            lcd.printf("Unable to connect, return code %d\n", connack_rc);
            goto exit;
        }
    }
    else 
    {
        lcd.printf("rc conn, %d\n", res);
        goto exit;
    }
    
    int rc = c->subscribe();
    res = MQTTPacket_read(buf, buflen, getdata);
    if (res == SUBACK)    /* wait for suback */
    {
        int submsgid;
        int subcount;
        int granted_qos;

        rc = MQTTDeserialize_suback(&submsgid, 1, &subcount, &granted_qos, buf, buflen);
        if (granted_qos != 0)
        {
            lcd.printf("granted qos != 0, %d\n", granted_qos);
            goto exit;
        }
    }
    else {
        lcd.printf("rc subs 2, %d\n", rc);
        goto exit;
        }
        
    char value[10];
    //string data_points = "";
    while(1) 
    {
        //Initialize lcd
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Mac address: %s\n", mac);
        //Flash led to show message has been sent successfully
        led1 = 1;
        string data_points = "\"myName\": \"IoT mbed\"";
        
        sprintf(value, "%0.4f", MMA.x());
        data_points+=",\"accelX\":";
        data_points+=value;
        sprintf(value, "%0.4f", MMA.y());
        data_points+=",\"accelY\":";
        data_points+=value;
        sprintf(value, "%0.4f", MMA.z());
        data_points+=",\"accelZ\":";
        data_points+=value;
        sprintf(value, "%0.4f", tmp.read());
        data_points+=",\"temp\":";
        data_points+=value;
        data_points+=",\"joystick\":" + joystickPos;
        pot1 = ain1;
        pot2 = ain2;
        sprintf(value, "%0.4f", pot1);
        data_points+=",\"potentiometer1\":";
        data_points+=value;
        sprintf(value, "%0.4f", pot1);
        data_points+=",\"potentiometer1\":";
        data_points+=value;
        
        string message = "{\"d\":{" + data_points + "}}";
        
        //TODO Get both publish and subscribe working togather
        //c->publish(message);//c->publish(m->convertToJson());
 
        led1 = 0;
        //TODO get subscription working consistently
        res = MQTTPacket_read(buf, buflen, getdata);
        if (  res == PUBLISH )
        {
            int dup;
            int qos;
            int retained;
            int msgid;
            int payloadlen_in;
            char* payload_in;
            int rc;
            MQTTString receivedTopic;

            rc = MQTTDeserialize_publish(&dup, &qos, &retained, &msgid, &receivedTopic,
                    &payload_in, &payloadlen_in, buf, buflen);
            char message[50];
            int i =0, charNums = 0;
            while(*payload_in && charNums <2) {
                charNums = 0;
                if(*payload_in == '\'') {
                    charNums++;
                    while(*payload_in != '\'') {
                        message[i] = *payload_in;
                        i++; payload_in++;
                    }
                    charNums++;
                }
                payload_in++;
            }
            message[i] = '\0';
            int count = getCount(payload_in);
            lcd.printf("Count %d\n", count);
            while(count) {
                led4 = 1;
                wait(0.5);
                led4 = 0;
                wait(0.5);
                count--;
            }
            
        }
        wait(1.0);
    }
exit:
    eth.disconnect();
}

int getCount(char* message) {
    cJSON *json;
    int count = 2;
    json = cJSON_Parse(message);
    if (!json) {
        lcd.printf("Error before: [%s]\n", cJSON_GetErrorPtr());
        wait(2.0);
    } else {
        count = cJSON_GetObjectItem(json, "count")->valueint;
        cJSON_Delete(json);
    }
    return count;
}

void joystickThread(void const *args) {
    while (1) {
        if (Down)
            joystickPos = "DOWN";
        else if (Left)
            joystickPos = "LEFT";
        else if (Click)
            joystickPos = "CLICK";
        else if (Up)
            joystickPos = "UP";
        else if (Right)
            joystickPos = "RIGHT";
        else
            joystickPos = "CENTRE";
    }
}
