/*******************************************************************************
* Copyright (c) 2014 IBM Corporation and other Contributors.
*
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors: Sam Danbury
* IBM - Initial Contribution
*******************************************************************************/

#include "MQTTPacket.h"
#include "rtos.h"
#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "ConfigFile.h"

#include <string>
#include <vector>
#include <map>
#include <sstream>
#include <algorithm>

#define IBM_IOT_BROKER "5.153.46.201"//"108.168.183.11" //-wdc01-2 msproxy //"208.43.110.186" //-wdc01-2 quickstart-msproxy  //"37.58.109.238"=old quickstart
#define IBM_IOT_PORT 1883

using namespace std;

class ExampleClient {
    public:
        bool connected;
        C12832_LCD lcd;
        TCPSocketConnection mysock;
        string macAddress;
        char topic[30];
        char subscribeTopic[30];
        bool quickstartMode;
        
        string org;
        string type;
        string id;
        string authMethod;
        string token;
                
        ExampleClient(string mac);
        void loadConfig();
        void tryMqttConnect();
        void connect();
        void publish(string payload);
        bool getConnection();
        int reconnectDelay(int attempt);
        int subscribe();
        //int* processEvents(char* buf, size_t count);
};