#include "mbed.h" 
#include "MFRC522.h" 
#include "ESP8266.h"               // Include header file from Author: Antonio Quevedo
#include "math.h"
#include <string>

// FRDM-K64F (Freescale) Pin for MFRC522 reset 
#define MF_RESET    PTD0 
#define SERIAL_1

#define APIKEY XE2W5EIXWN6LA234    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "RajasiPhone"
#define WIFI_PASS "youcantguessmypassword"

Serial pc(USBTX,USBRX);

ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi

char snd[255],rcv[1000],snd_Data[255];           //snd= string used to send command to ESP 8266 wii and  rcv = string used to receive response from ESP8266 wifi module 

void esp_initialize(void); // Function used to initialize ESP8266 wifi module 
void esp_send(void);       // Function used to connect with thingspeak.com and update channel using ESP8266 wifi module 


DigitalOut LedGreen(LED2); 

//Serial connection to PC for output 
//Serial pc(PTC17, PTC16); // serial comm on the FRDM board

//wireless bluetooth connection to Android Device for output
Serial blue(PTC15, PTC14);   

 
//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET); 
MFRC522    RfChip   (PTD2, PTD3, PTD1, PTE25, PTD0); 
 
int counter1 = 0;
int counter2 = 0; 
 
int main(void) { 
   
   blue.baud(9600);
   pc.baud(115200);
   pc.printf("Welcome to RFID Tag Reader Using FRDM K64F...\n\r");
   blue.printf("Welcome to RFID Tag Reader Uing FRDM K64F...\n\r");
   pc.printf("Bluetooth Enable\r\n");
   blue.printf("Bluetooth Enable\r\n");
   RfChip.PCD_Init();
   
   
    //pc.baud(115200);           // Baud rate used for communicating with Tera-term on PC
    
    pc.printf("START\r\n");  // Starting point
    
    esp_initialize();
   
    
 
   while (true) { 
     LedGreen = 1; 
 
     // Look for new cards 
     if ( ! RfChip.PICC_IsNewCardPresent()) 
     { 
       wait_ms(200); 
       continue; 
     } 
 
     // Select one of the cards 
     if ( ! RfChip.PICC_ReadCardSerial()) 
     { 
       wait_ms(200); 
       continue; 
     } 
      LedGreen = 0;
      int a=0; 
 
     // Print Card UID 
     pc.printf("Card UID:"); 
     blue.printf("Card UID:");
     for (uint8_t i = 0; i < RfChip.uid.size; i++) 
     { 
      pc.printf(" %X02 ", RfChip.uid.uidByte[i]);
      blue.printf(" %X02 ", RfChip.uid.uidByte[i]);
      a = RfChip.uid.uidByte[0];
     }  
     printf("%d",a);
     
     //Print Card Type
    if(a==73)
    { 
    if(counter1 == 0){
         pc.printf("\r\nMilk is in the fridge");
         blue.printf("\r\nMilk is in the fridge");
         counter1 = 1;
         
     }
     else if(counter1 == 1){
         pc.printf("\r\nMilk is out of the fridge");
         blue.printf("\r\nMilk is in out of the fridge");
         counter1 = 0;
         esp_send();
         }
     }
    
     if(a==207)
     {
    if (counter2 == 0)
    {
    printf("\r\nBeer is in the fridge");
    blue.printf("\r\nBeer is in the fridge");
    counter2 = 1;
    }
    else if (counter2 == 1){
    printf("\r\nBeer is out of the fridge");
    blue.printf("\r\nBeer is in out of the fridge");
    counter2 = 0;
    esp_send();
    }
    }
    //wait(1);
   //  else
   //  {
    //     printf("\r\nUnrecognized");
     //    blue.printf("\r\nUnrecognized");
     //}     
     printf("\n\r"); 
     blue.printf("\n\r"); 
     
     // Print RFID Card type 
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak); 
     printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));
     blue.printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));
     
     wait(2);
     
   } 
 } 
 void esp_initialize(void)
{    
    pc.printf("Initializing ESP\r\n"); 
      
    pc.printf("Reset ESP\r\n"); 
    esp.Reset();                   //RESET ESP
    esp.RcvReply(rcv, 400);        //receive a response from ESP
    //pc.printf(rcv);          //Print the response onscreen 
    wait(2);
    
    strcpy(snd,"AT");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf(rcv);      
    wait(0.1);
    
    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");
    
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
    
    strcpy(snd,"AT+CIPMUX=0");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 

}


void esp_send(void)
{
   int field1 = 0;
   int field2 = 0;
    //ESP updates the Status of Thingspeak channel//
    
    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");
    
    esp.SendCMD(snd); 
    pc.printf("S\r\n%s",snd);
    //wait(2);                                                    
    esp.RcvReply(rcv, 1000);
    pc.printf("R\r\n%s",rcv);
    wait(1);
    
    sprintf(snd,"GET https://api.thingspeak.com/update?key=XE2W5EIXWN6LA234&field1=%d&field2=%d\r\n",field1,field2);
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    
    sprintf(cmd,"AT+CIPSEND=%d",i);                                       //Send Number of open connection and Characters to send 
    esp.SendCMD(cmd);
    pc.printf("S\r\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    
    esp.SendCMD(snd);                                                      //Post value to thingspeak channel
    pc.printf("S\r\n%s",snd);
    
    while(i<=20 || rcv == "OK")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    
}

