#include "mbed.h"
#include "rtos.h"

void write_to_master(char);                    //function to write data to master
Thread * ptr_t_i2c;
I2CSlave slave(D14,D15);                       //configuring pins p27, p28 as I2Cslave
Serial pc (USBTX,USBRX);
InterruptIn slave_intrpt(D9);

DigitalOut master_intrpt(D10);

int i2c_status=0;                                 //read/write mode for i2c 0 : write2slave, 1 : write2master
int reset=0;
int temp;


typedef struct
{
    char data;          // To avoid dynamic memory allocation
    int length;
}i2c_data;

Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;
 

void FUNC_I2C_WRITE2CDMS(char *data, int length=1)
{
       int slave_status = 1;
   
    while(slave_status && slave_intrpt == 1)
    {                 
            slave.address(0x20);
           // volatile unsigned char *reg = (unsigned char*)0x40067000;
    //printf(" %d \n", *reg );
            if(slave.receive()==1)
            {
                slave_status=slave.write(data,length);
               
                
            }
            else if(slave.receive()==3 || slave.receive()==2)
            {
                slave_status=slave.read(data,length);
            }
            break;
            
     }
            //printf("\ndone\n\r");

}

void T_I2C_BAE(void const * args)
{
    char data_send,data_receive;
        Thread::signal_wait(0x1);
        //i2c_status = temp;
        //wait(0.5);
        //printf("\n entered thread\n\r");
        if(i2c_status == 0 )
        {
            
            FUNC_I2C_WRITE2CDMS(&data_receive);
        i2c_data * i2c_data_r = new i2c_data;
        //USE i2c_data_r fo various operations
            //printf("\n Data received from CDMS is %c\n\r",data_receive);
                                          // This has to be done from a differen thread
            
        }
        else if(i2c_status ==1)
        {
            
            if (1==1) 
            {
                FUNC_I2C_WRITE2CDMS(&data_send);
                //printf("\nData sent to CDMS is %c\n\r",data_send);
               
                i2c_status = 0;
                //temp = i2c_status;
            }
        }  
           
    
}
        
void FUNC_INT()
{
   reset = 0;
   ptr_t_i2c->signal_set(0x1);
     
}

void FUNC_RESET()
{
    reset = 1;
}

void ir2master()
{
        
        char data='a';
        master_intrpt=0;
        data = pc.getc();
        reset =0;
        i2c_status=1;
        master_intrpt=1;
        i2c_data * i2c_data_s = i2c_data_send.alloc();
        i2c_data_s->data = data;
        i2c_data_s->length = 1;
        i2c_data_send.put(i2c_data_s); 
        
        //temp = i2c_status;
}
      
   


int main()
{   
    printf("\n slave started\n\r");
    
    ptr_t_i2c = new Thread(T_I2C_BAE);
   
    slave_intrpt.rise(&FUNC_INT);
    while(1)
    {
      ir2master(); 
                
    }
     
}



