#include "mbed.h"
#include "pin_config.h"
#include "rtos.h"
#define tm_len 1100
#define tc_len 150
#define hk_len 150

Serial pc(USBTX,USBRX);
InterruptIn irpt_4m_slv(PIN39);                                      //I2c interrupt from CDMS
DigitalOut irpt_2_slv(PIN67);                                        //I2C interrupt to CDMS
I2C master(PIN32,PIN31);
DigitalOut led1(PIN46);
DigitalOut led2(PIN95);
const int addr = 0x20;                                            //slave address 
char hk_data[hk_len];
char telecommand[tc_len];
char telemetry[tm_len];
Timer test;
Timer t_read;
bool write_ack = true;
bool read_ack = true;
char cmd = 'r';

Thread *ptr_t_i2c;

void FCTN_I2C_READ(char*,int);
void FCTN_I2C_WRITE(char*,int);
void FCTN_ISR_I2C();
int count = 0;
void FCTN_MASTER_CMD()
{   
    switch(cmd)
    {
        case 'r':
        pc.printf("\n \r %d CDMS READ MODE\n",count);
        FCTN_I2C_READ(hk_data,hk_len);
        cmd = 'w';
        count ++;
        break;
        
        case 'w':
        pc.printf("\n \r %d CDMS WRITE MODE\n",count);
        FCTN_I2C_WRITE(telecommand,tc_len);
        //strcat(telecommand,"1");
        cmd = 'r';
        count++;
        break;
    }
}

void FCTN_I2C_WRITE(char *data,int length)
{
    irpt_2_slv = 1;
    //t.start();
    write_ack = master.write(addr|0x00,data,length);
    //t.stop();
    //if(write_ack == 0)
        //pc.printf("\n\r data not sent \n");
       
if (write_ack == 1)
    {
        led2 = 1;
        pc.printf("\n\r data not sent \n");
        led2 = 0;    
    }
    irpt_2_slv = 0;
    //pc.printf("\n\r %d \n",t.read_us());
    //t.reset();
}


void FCTN_I2C_READ(char *data,int length)
{
    irpt_2_slv = 1; 
    t_read.start();
    read_ack = master.read(addr|1,data,length);
    t_read.stop();
   
    //if(read_ack == 0)
      //  pc.printf("\n\rData received from BAE %s \n",data);
 if (read_ack == 1)
    {
        led2 = 1;
        pc.printf("\n \r data not received \n");
        led2 = 0;
    }
//if(read_ack == 1)
//pc.printf("\n \r data not received \n");

    irpt_2_slv = 0;
    //pc.printf("\n\r %d \n",t.read_us());
    //t.reset();
}

void FCTN_ISR_I2C()
{ 
    //led1 = 1;
    //pc.printf("in isr");  
   ptr_t_i2c->signal_set(0x1); 
    //test.start();
    //wait(0.5);
    //led1 = 0;
}

void T_TM(void const * args)
{
     while(1)
    {
        Thread::signal_wait(0x1);
      // wait(2);
        //test.stop();
        led1 = 1;
       // wait(3);
        FCTN_I2C_READ(telemetry,tm_len);
        led1 = 0;
        //pc.printf("\n \r %d",test.read_us());
        //test.reset();
        //irpt_2_slv = 1; 
//    t.start();
//    read_ack = master.read(addr|1,telemetry,150);
//    t.stop();
//    if(read_ack == 0)
//        pc.printf("\n\rData received from BAE. %s \n",telemetry);
//    else
//    {
//        pc.printf("\n \r data not received \n");
//    }
//    irpt_2_slv = 0;
//    pc.printf("\n\r %d \n",t.read_us());
//    t.reset();
//        pc.printf("\n\r Telemetry Received \n"); 
    } 
}

int main()
{
  pc.printf("\n\r MASTER ACTIVATED\n");
  master.frequency(100000);  
  ptr_t_i2c = new Thread(T_TM);     
  ptr_t_i2c->set_priority(osPriorityHigh);
  strcpy(telecommand," Telecommand1 : This is test telecommand. Verifying fuctionality. Yippee!!! It is working!!!!!!!!!!!!!");
  irpt_2_slv = 0;
  irpt_4m_slv.enable_irq();
  //irpt_4m_slv.mode(PullDown);
  irpt_4m_slv.rise(&FCTN_ISR_I2C);
  while(1)
  {
      Thread::wait(2000);
      //ptr_t_i2c->signal_set(0x1); 
      pc.printf("\n\rTELEMETRY received from BAE is %d %s \n",t_read.read_us(),telemetry);
      pc.printf("\n\rHK Data received from BAE is %d %s \n",t_read.read_us(),hk_data);
       t_read.reset();
      FCTN_MASTER_CMD();
  }
}