#include "EPS.h"
#include "pin_config.h"
/***********************************************global variable declaration***************************************************************/
extern uint32_t BAE_STATUS;
extern uint32_t BAE_ENABLE;
extern char hk_data[25];
const char RCOMP0= 0x97;                 
SensorData Sensor; 
SensorDataQuantised SensorQuantised;
ShortBeacy Shortbeacon;


/***********************************************Configuring Peripherals*******************************************************************/
Serial pc_eps(USBTX,USBRX);

I2C BG_I2C(D14,D15);                                           //i2c btwn bae and battery gauge
DigitalOut SelectLinesA[] = {PIN43,PIN44,PIN45,PIN46};         //to mux1=>voltage mux , PTA 13-16 , CHNGE TO PIN43 LATER
DigitalOut SelectLinesB[] = {PIN56,PIN57,PIN58,PIN59};         //to mux2=>current mux(differential mux) , PTB 3,7,8,9
                                                               //MSB is SelectLines[0],LSB is SelectLines[3]
AnalogIn CurrentInput(PIN53);                                  // output from Current Mux PTB0
AnalogIn VoltageInput(PIN54);                                  // output from Voltage Multiplexer  PTB1
AnalogIn Vbatt_ang(VBATT);                                         //VBATT of battery gauge

SPI BTemp_spi(PTD6,PTD7,PTD5); //MOSI,MISO,SLK
DigitalOut BTemp_ssn1(PTD4); //Slave select1
DigitalOut BTemp_ssn2(PTD2);//Slave select2
DigitalOut BTemp_PS(PTB0);
DigitalOut BTemp_HS(PTB1);

DigitalOut TRXY(TRXY_DR_EN);            //active high
DigitalOut TRZ(TRZ_DR_EN);              //active high
DigitalOut EN3V3A(ENBL3V3A);
DigitalOut EN_BTRY_HT(BATT_HEAT);
//DigitalIn BTRY_HT_OUTPUT(BATT_HEAT_OUTPUT);

//*********************************************************flags********************************************************//
extern char EPS_INIT_STATUS ;
extern char EPS_BATTERY_GAUGE_STATUS ;
extern char EPS_MAIN_STATUS;
extern char EPS_BATTERY_TEMP_STATUS ;
extern char EPS_STATUS ;

extern char EPS_BATTERY_HEAT_ENABLE ;

//----------------------------------------------------EPS INIT---------------------------------------------------------------------------//
void FCTN_EPS_INIT()
{
    printf("\n\r eps init \n");
    EPS_INIT_STATUS = 's' ;             //set EPS_INIT_STATUS flag
    FLAG();
    FCTN_EPS_BG_INIT();   
    FCTN_EPS_BTEMP_INIT();
    EN3V3A = 1;                             //enable dc dc converter A  
    char value=BG_alertFlags();
    unsigned short value_u= (short int )value;
    value_u &=0x0001;                     
    if(value_u ==0x0001)                       // battery gauge not initialised
    {
        Sensor.power_mode = 1; 
        Sensor.SOC = 80;            //dummy
        FCTN_EPS_POWERMODE(Sensor.SOC);
        EPS_BATTERY_GAUGE_STATUS = 'c';               //clear EPS_BATTERY_GAUGE_STATUS
    }
    else
    {
        Sensor.SOC = BG_soc();
        Sensor.SOC = 80;            //dummy
        Sensor.Vbatt = Vbatt_ang.read()*3.3;
        FCTN_EPS_POWERMODE(Sensor.SOC);
        EPS_BATTERY_GAUGE_STATUS = 's';               //set EPS_BATTERY_GAUGE_STATUS
    }
   
    EPS_INIT_STATUS = 'c' ;             //clear EPS_INIT_STATUS flag

}

//---------------------------------------------battery Temp sensor code------------------------------------------------------------------//
void FCTN_EPS_BTEMP_INIT()
{
    BTemp_ssn1=1;BTemp_ssn2=1;
    BTemp_PS=0;             //power switch control enable
    BTemp_HS=0;             //heater switch
    BTemp_spi.format(8,3);
    BTemp_spi.frequency(1000000);
}

//----------------------------------------------------Battery Gauge code-----------------------------------------------------------------//

void FCTN_EPS_BG_INIT()
{
    BG_disableSleep();
    BG_disableHibernate();
    BG_socChangeAlertEnabled(true); //enabling alert on soc changing by 1%
    BG_emptyAlertThreshold(32);//setting empty alert threshold to 32% soc
    BG_vAlertMinMaxThreshold();//set min, max value of Valrt register
    BG_vResetThresholdSet();//set threshold voltage for reset
    BG_vResetAlertEnabled(true);//enable alert on reset for V < Vreset
}

unsigned short BG_readReg(char reg)
{
    //Create a temporary buffer
    char buff[2] = {0,0};
 
    //Select the register
    BG_I2C.write(BG_ADDR, &reg, 1, true);
 
    //Read the 16-bit register
    BG_I2C.read(BG_ADDR, buff, 2);
 
    //Return the combined 16-bit value
    return (buff[0] << 8) | buff[1];
}

void BG_writeReg(char reg, unsigned short data)
{
    //Create a temporary buffer
    char buff[3];
 
    //Load the register address and 16-bit data
    buff[0] = reg;
    buff[1] = data >> 8;
    buff[2] = data;
 
    //Write the data
    BG_I2C.write(BG_ADDR, buff, 3);
}
   
 
 
// Command the MAX17049 to perform a power-on reset
void BG_reset()                         
{
    //Write the POR command
    BG_writeReg(REG_CMD, 0x5400);
}
    
// Command the MAX17049 to perform a QuickStart
void BG_quickStart()                    
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_MODE);
 
    //Set the QuickStart bit
    value |= (1 << 14);
 
    //Write the value back out
    BG_writeReg(REG_MODE, value);
}
    
    
//disable sleep
void BG_disableSleep()
{
    unsigned short value = BG_readReg(REG_MODE);
    value &= ~(1 << 13);
    BG_writeReg(REG_MODE, value);
}
  
//disable the hibernate  of the MAX17049
void BG_disableHibernate()
{
    BG_writeReg(REG_HIBRT, 0x0000);
}
  
    
// Enable or disable the SOC 1% change alert on the MAX17049
void BG_socChangeAlertEnabled(bool enabled)
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_CONFIG);
 
    //Set or clear the ALSC bit
    if (enabled)
        value |= (1 << 6);
    else
        value &= ~(1 << 6);
 
    //Write the value back out
    BG_writeReg(REG_CONFIG, value);
} 

float BG_compensation()
{
    //Read the 16-bit register value
    unsigned short value = BG_readReg(REG_CONFIG);
 
    //Return only the upper byte
    return (char)(value >> 8);
}
 
void BG_compensation(char rcomp)
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_CONFIG);
 
    //Update the register value
    value &= 0x00FF;
    value |= rcomp << 8;
 
    //Write the value back out
    BG_writeReg(REG_CONFIG, value);
}

 
void BG_tempCompensation(float temp)
{
    //Calculate the new RCOMP value
    char rcomp;
    if (temp > 20.0) {
        rcomp = RCOMP0 + (temp - 20.0) * -0.5;
    } else {
        rcomp = RCOMP0 + (temp - 20.0) * -5.0;
    }
 
    //Update the RCOMP value
    BG_compensation(rcomp);
}

// Determine whether or not the MAX17049 is asserting the ALRT pin
bool BG_alerting()
{
    //Read the 16-bit register value
    unsigned short value = BG_readReg(REG_CONFIG);
 
    //Return the status of the ALRT bit
    if (value & (1 << 5))
        return true;
    else
        return false;
}
    
// Command the MAX17049 to de-assert the ALRT pin
void BG_clearAlert()
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_CONFIG);

    //Clear the ALRT bit
    value &= ~(1 << 5);
 
    //Write the value back out
    BG_writeReg(REG_CONFIG, value);
}
  
 
//Set the SOC empty alert threshold of the MAX17049
void BG_emptyAlertThreshold(char threshold)
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_CONFIG);

    //Update the register value
    value &= 0xFFE0;
    value |= 32 - threshold;
 
    //Write the 16-bit register
    BG_writeReg(REG_CONFIG, value);
}
    
// Set the low and high voltage alert threshold of the MAX17049
void BG_vAlertMinMaxThreshold()
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_VALRT);
 
    //Mask off the old value
    value = 0x96D2;                 // threshold is betweeen 6 and 8.4 v                     
     
    //Write the 16-bit register
    BG_writeReg(REG_VALRT, value);
}

    
// Set the reset voltage threshold of the MAX17049
void BG_vResetThresholdSet()
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_VRESET_ID);
 
    //Mask off the old //value
    value &= 0x00FF;//Dis=0
 
    value |= 0x7C00;//corresponding to 2.5 V
    
 
    //write the 16-bit register
    BG_writeReg(REG_VRESET_ID, value);
}
        
    
// Enable or disable the voltage reset alert on the MAX17049
void BG_vResetAlertEnabled(bool enabled)
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_STATUS);
    
    //Set or clear the EnVR bit
    if (enabled)
        value |= (1 << 14);
    else
        value &= ~(1 << 14);
 
    //Write the value back out
    BG_writeReg(REG_STATUS, value);
}
 
//Get the current alert flags on the MAX17049
//refer datasheet-status registers section to decode it.
char BG_alertFlags()
{
    //Read the 16-bit register value
    unsigned short value = BG_readReg(REG_STATUS);
 
    //Return only the flag bits
    return (value >> 8) & 0x3F;
}
    
// Clear all the alert flags on the MAX17049
void BG_clearAlertFlags()
{
    //Read the current 16-bit register value
    unsigned short value = BG_readReg(REG_STATUS);
 
    //Clear the specified flag bits
    value &= ~( 0x3F<< 8);
 
    //Write the value back out
    BG_writeReg(REG_STATUS, value);
}
    
// Get the current cell voltage measurement of the MAX17049
float BG_vcell()
{
    //Read the 16-bit raw Vcell value
    unsigned short value = BG_readReg(REG_VCELL);
 
    //Return Vcell in volts
    return value * 0.000078125*2;
}
    
// Get the current state of charge measurement of the MAX17049 as a float
float BG_soc()
{
    //Read the 16-bit raw SOC value
    unsigned short value = BG_readReg(REG_SOC);
 
    //Return SOC in percent
    return value * 0.00390625;
}
    
   
 
// Get the current C rate measurement of the MAX17049
float BG_crate()
{
    //Read the 16-bit raw C/Rate value
    short value = BG_readReg(REG_CRATE);
 
    //Return C/Rate in %/hr
    return value * 0.208;
}


//----------------------------------------------------Power algo code--------------------------------------------------------------------//
void FCTN_EPS_POWERMODE(float soc)              //dummy algo
{
    if(soc >= 80)
        Sensor.power_mode = 4;
    else if(soc >= 70 & soc < 80)
        Sensor.power_mode = 3;
    else if(soc >= 60 & soc < 70)
        Sensor.power_mode = 2;
    else if(soc < 60)
        Sensor.power_mode = 1;
}