#include "mbed.h"
#include "pin_config.h"
//.............Power switching..........
#define TRXY_DR_EN PIN82                  //torque rod driver enable
#define TRZ_DR_EN  PIN88  
#define 3V3AENBL PIN33
#define VBATT PIN20
//......................HK.....................
#define vstart 3.3
#define vstep 0.84667
#define cstart 0.0691
#define cstep 0.09133
#define tstart -40
#define tstep  8.33 
#define rsens 0.025                         
#define Bnewvalue_start -100//in microTesla...max possible field is .0001 T 
#define Bnewvalue_step 13.333
#define AngularSpeed_start -10//max possible ang. velocity in space is 10 deg/sec
#define AngularSpeed_step 1.3333 
//...............Battery Gauge................
#define BG_ADDR       (0x6C)       //slave address of battery gauge
//I2C register addresses 
#define REG_VCELL        0x02
#define REG_SOC          0x04
#define REG_MODE         0x06
#define REG_VERSION      0x08
#define REG_HIBRT        0x0A
#define REG_CONFIG       0x0C
#define REG_VALRT        0x14
#define REG_CRATE        0x16
#define REG_VRESET_ID    0x18
#define REG_STATUS       0x1A
#define REG_TABLE        0x40
#define REG_CMD          0xFE


typedef struct SensorData                 
{
    float SOC;          //added recently
    float Vbatt;        //added recently
    float Voltage[15];
    float Current[7];
    float Temperature[1];      // not finalised
    //float PanelTemperature[4];      // not finalised   ///there wer 4 values here?
    float BatteryTemperature;   
    char fault_poll;             //polled faults
    char fault_ir;               //interrupted faults
    char clear_fault_poll;      //to be confirmed
    char clear_fault_ir;
    char power_mode;            //power modes
    float AngularSpeed[3];      //in order x,y,z
    float Bnewvalue[3];         //in order Bx,By,Bz
} SensorData;

 
typedef struct SensorDataQuantised 
{
    char Voltage[8];
    char Current[4];
    char Temperature[2];  ///size??????
    //char PanelTemperature[2];//read by the 4 thermistors on solar panels
    char BatteryTemperature;    //to be populated   
    char faultpoll;             //polled faults
    char faultir;               //interrupted faults
    char power_mode;            //power modes
    char AngularSpeed[2];
    char Bnewvalue[2];
    
    //float magnetometer,gyro=>to be addes
} SensorDataQuantised;
 
 
typedef struct ShortBeacon 
{
    char Voltage[1];                            //battery voltage from gauge, needs  to be quantised
    char AngularSpeed[2];                       //all the 3 data
    char SubsystemStatus[1];                    //power modes
    char Temp[2];                               //temp of solar panel
    //Temp[0]'s LSB=> PanelTemperature[0], Temp[0]'s MSB=> PanelTemperature[1], Temp[1]'s LSB=> PanelTemperature[2], Temp[1]'s MSB=> PanelTemperature[3]
    char ErrorFlag[1];                          //fault
}ShortBeacy; 
 

/******************************************************function headers************************************************************************/ 
void FCTN_EPS_INIT(); 

void FCTN_EPS_BTEMP_INIT();
void FCTN_EPS_BTEMP_MAIN(float*);

unsigned short BG_readReg(char);
void BG_writeReg(char, unsigned short);
void BG_reset();                        //not used in code
void BG_quickStart();                   //not used in code
void BG_disableSleep();         
void BG_disableHibernate();
void BG_socChangeAlertEnabled(bool);
float BG_compensation();                //not used in code
void BG_compensation(char);
void BG_tempCompensation(float);
bool BG_alerting();
void BG_clearAlert();
void BG_emptyAlertThreshold(char);
void BG_vAlertMinMaxThreshold();
void BG_vResetThresholdSet();
void BG_vResetAlertEnabled(bool);
char BG_alertFlags();
void BG_clearAlertFlags();
float BG_vcell();
float BG_soc();
void FCTN_EPS_BG_INIT();
void FCTN_EPS_BG_MAIN();

int FCTN_EPS_POWERMODE(float); 
void FCTN_EPS_CTRLPOWER(int) ;

int FCTN_QUANTIZE(float ,float ,float );
void FCTN_WRITE_BEASTRUCT(ShortBeacy* ,SensorDataQuantised );
void FCTN_EPS_HK_MAIN();

 
