#include "mbed.h"
#include "rtos.h"

const int addr = 0x20;                     //slave address 
I2C master (D14,D15);                      //configure pins p27,p28 as I2C master
Serial pc (USBTX,USBRX);
DigitalOut interrupt(D9);
InterruptIn data_ready(D10);

int reset;

typedef struct
{
    char data[35];          // To avoid dynamic memory allocation
    int length;
}i2c_data;

Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;

Thread * ptr_t_i2c;
void FUNC_I2C_MASTER_FSLAVE(char * data,int length)
{
    //printf("press backspace for master to start \n\r");
    //while(1){
            //interrupt = 0;
      //  if(pc.getc()=='z'){
            wait(0.5);
            interrupt = 1;
            printf("\nMaster executed\n");
            
          
            bool ack0 =true; 
            bool loopvariable0 =true;
            //char *data =  new char;
            //*data = 'b';
           
           
            
             master.frequency(100000);                       //set clock frequency
             //master.start();
            /*while(write2slave)
            {  *writedata = pc.getc();
            wait(0.5);
              
                printf("master clk freq setup and addressing slave\n\r");
                master.start();                                 //initiating the data transfer
                master_status_write = (bool) master.write(addr|0x00,writedata,1);
                if(master_status_write==0)
                {
                    printf("master has written %c to slave\n\r",*writedata);
                    write2slave=false;
                }
                    
                    
             }*/
             
            while(ack0)
            {
                //printf("2 master clk freq setup and addressing slave\n\r");
                
                master.start();                                 //initiating the data transfer
                ack0 =  master.read(addr,data,length);
            }
            if(!ack0)
            {
                    printf("\n master has read %s from slave\n\r",data);
                    loopvariable0=false;
            }
                //master.stop();
            
            //printf("done\n\r");
            //delete data;
            interrupt=0;
}
            
void T_I2C_MASTER_FSLAVE(void const *args)
{
    char data_receive[35];
    while(1)
    {
        Thread::signal_wait(0x1);
        FUNC_I2C_MASTER_FSLAVE(data_receive,35);
        i2c_data * i2c_data_r = i2c_data_receive.alloc();
        strcpy(i2c_data_r->data , data_receive);
        i2c_data_r->length = 35;
        i2c_data_receive.put(i2c_data_r);
        printf("\n Data received from slave is %s\n\r",data_receive);
        i2c_data_receive.free(i2c_data_r);
    }
}

void FUNC_INT()
{
  
   ptr_t_i2c->signal_set(0x1);
     
}

char writedata[35];
bool write2slave;
bool master_status_write;
void FUNC_MASTER_WRITE()
{   //wait(1);
    write2slave=true;
   
    interrupt = 1;
     
    char data[35];
    strcpy(data,"sakthi");
    strcat(data,"priya");
    i2c_data * i2c_data_s = i2c_data_send.alloc();
    strcpy(i2c_data_s->data ,data);
    i2c_data_s->length = 35;
    i2c_data_send.put(i2c_data_s); 
    master_status_write = true;
    
   // interrupt = 1; 

    osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                strcpy(writedata ,i2c_data_s -> data);
                master.frequency(100000);                        //set clock frequency
                while(write2slave)
                {                
                printf("master clk freq setup and addressing slave\n\r");
                master.start();                                 //initiating the data transfer
                master_status_write = (bool) master.write(addr|0x00,writedata,35);
                if(master_status_write==0)
                    {
                    printf("master has written %s to slave\n\r",writedata);
                    write2slave=false;
                    }
                i2c_data_send.free(i2c_data_s);
                }
            }
            interrupt = 0;
}

    

int main()
{   
    ptr_t_i2c = new Thread(T_I2C_MASTER_FSLAVE);
    data_ready.rise(&FUNC_INT);
    printf("\nstarted master\n"); 
    while(1)
    { Thread::wait(8000);
    //interrupt = 1;
      
      FUNC_MASTER_WRITE(); 
      //interrupt = 0; 
      ;
    }
}           