#include "mbed.h"
#include "rtos.h"
#include "slave.h"

void write_to_master(char);                    //function to write data to master

I2CSlave slave(D14,D15);                       //configuring pins p27, p28 as I2Cslave

Serial pcslave(USBTX, USBRX);
DigitalOut data_ready(D10);
int i2c_status=0;                                 //read/write mode for i2c 0 : write2slave, 1 : write2master
int reset=0;
int temp;

typedef struct
{
    char data;          // To avoid dynamic memory allocation
    int length;
}i2c_data;



Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;
 

void FUNC_I2C_WRITE2CDMS(char *data, int length=1)
{
       int slave_status = 1;
   
    while(slave_status)
    {                 
            slave.address(0x20);
            if(slave.receive()==1)
            {
                slave_status=slave.write(data,length);
               
                
            }
            else if(slave.receive()==3 || slave.receive()==2)
            {
                slave_status=slave.read(data,length);
            }
            
    }
            printf("\ndone\n\r");

}
char data_send,data_receive;
void T_I2C_BAE()
{
    //char data_send,data_receive;
    //while(1)
    //{
       // Thread::signal_wait(0x1);
        //i2c_status = temp;
        //wait(0.5);
        printf("\n entered thread\n\r");
        if(i2c_status == 0 && reset !=1)
        {
            
            FUNC_I2C_WRITE2CDMS(&data_receive);
            i2c_data * i2c_data_r = i2c_data_receive.alloc();
            i2c_data_r->data = data_receive;
            i2c_data_r->length = 1;
            i2c_data_receive.put(i2c_data_r);
            printf("\n Data received from CDMS is %c\n\r",data_receive);
            i2c_data_receive.free(i2c_data_r);                              // This has to be done from a differen thread
            
        }
        else if(i2c_status ==1 && reset !=1)
        {
            osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                data_send = i2c_data_s -> data;
                FUNC_I2C_WRITE2CDMS(&data_send);
                printf("\nData sent to CDMS is %c\n\r",data_send);
                i2c_data_send.free(i2c_data_s);
                i2c_status = 0;
                //temp = i2c_status;
            }
        }  
           
    //}
}

        

void FUNC_INT()
{
   reset = 0;
   
     
}

void FUNC_RESET()
{
    reset = 1;
}

void ir2master()
{
        
        char data='a';
        data_ready=0;
        data = pcslave.getc();
        reset =0;
        i2c_status=1;
        i2c_data * i2c_data_s = i2c_data_send.alloc();
        i2c_data_s->data = data;
        i2c_data_s->length = 1;
        i2c_data_send.put(i2c_data_s); 
        data_ready=1;
        //temp = i2c_status;
}
      
   
   



