#include "mbed.h"
#include "stdio.h"
#include "stdint.h"
#include "stdlib.h"
#include "SPI.h"
#include "SDFileSystem.h"

Serial terminal(USBTX, USBRX);

//Create an SDFileSystem object
SDFileSystem sd(PA_7, PA_6, PA_5, PB_6, "sd"); // mosi, miso, sclk, cs

int main()
{
   wait(0.5);
    terminal.baud(115200);
    //Mount the filesystem
   sd.mount();
    //Perform a write test
    printf("\nWriting to SD card...");
    FILE *fp = fopen("/sd/sdtest.txt", "w");
    if (fp != NULL) {
        fprintf(fp, "We're writing to an SD card!");
        fclose(fp);
        printf("success!\n");
    } else {
        printf("failed!\n");
    }

    //Perform a read test
    printf("Reading from SD card...");
    fp = fopen("/sd/sdtest.txt", "r");
    if (fp != NULL) {
        char c = fgetc(fp);
        if (c == 'W')
            printf("success!\n");
        else
            printf("incorrect char (%c)!\n", c);
        fclose(fp);
    } else {
        printf("failed!\n");
    }
    sd.unmount();
    //Unmount the filesystem
 // sd.unmount();
}
