#ifndef HC05_H
#define HC05_H

#define B9600 "9600, 0,0"
#define B19200 "19200, 0,0"
#define B38400 "38400, 0,0"
#define B57600 "57600, 0,0"
#define B115200 "115200, 0,0"

enum UART {UART1, UART6};
enum CMODE {FIXED, ANY, CSLOOP};
enum ROLE {SLAVE, MASTER, RSLOOP};

class bt_modul_hc05
{
public :
    void initUART(UART num, unsigned long baudrate, _IRQ interrupt);
    char *get_version();
    char *get_modul_address();
    char *get_modul_name();
    char *get_device_name();
    char *get_modul_role();
    char *get_device_class();
    char *get_modul_giac();
    char *get_modul_inquiry();
    char *get_modul_pincode();
    char *get_modul_uart();
    char *get_modul_inqm();
    char *get_modul_init();
    char *get_modul_state();
    char *get_addr_mode();
    char *get_fixed_addr();
    
    char *set_reset();
    char *set_default_settings();
    char *set_modul_role(ROLE role);
    char *set_device_class(int dclass);
    char *set_modul_giac(char *giac);
    char *set_modul_pincode(char *pin);
    char *set_modul_inquiry(char *inqparams);
    char *set_modul_inqc();
    char *set_modul_name(char *name);
    char *set_modul_uart(char *uartparams);
    char *set_addr_fixed(char *address);
    char *set_addr_mode(CMODE mode);
    char *search_device(char *address);
    char *set_device_paired(char *address, int timeout);
    char *delete_device(char *address);
    char *delete_all();
    char *connect_device(char *address);
    char *disconnect_device(char *address);
    
    bool data_send(char *data);
    char *data_receive();
    void flush();
    
    char *search_device();
    
    char *link_device_any(char *address);
    char *link_device_fixed(char *address);
    char *link_device_paired(char *address);
    void init_master_fixed(char *address);
    void init_slave();
private :
    _IRQ t_interrupt;
    _IRQ t_interrupt1;
    UART t_uart;
};

#endif