#include "mbed.h"
#include "at.h"
#include "hc05.h"


void bt_modul_hc05::initUART(UART num, unsigned long baudrate, _IRQ interrupt)
{
    t_uart = num;

    switch(t_uart)  {
        case UART1 :
            at0.device_init(baudrate, interrupt);
            t_interrupt = interrupt;
            break;
        case UART6 :
            at1.device_init1(baudrate, interrupt);
            t_interrupt1 = interrupt;
            break;
    }

}

char *bt_modul_hc05::get_version()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+VERSION?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+VERSION?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}

char *bt_modul_hc05::set_reset()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+RESET\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+RESET\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}

char *bt_modul_hc05::set_default_settings()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+ORGL\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+ORGL\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_address()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+ADDR?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+ADDR?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_name()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+NAME?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+NAME?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_device_name()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+RNAME?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+RNAME?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_role()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+ROLE?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+ROLE?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_device_class()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+CLASS?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+CLASS?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_giac()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+IAC?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+IAC?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_inquiry()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+INQM?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+INQM?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_pincode()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+PSWD?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+PSWD?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_uart()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+UART?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+UART?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_inqm()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+INQ\r\n", "");

            if(t_interrupt == OFF)  {
                return at0.getAnswer(24000);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+INQ\r\n", "");

            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(24000);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_modul_init()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+INIT\r\n", "");

            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }


        case UART6 :
            at1.at_send("AT+INIT\r\n", "");

            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }


    }
    return 0;

}

char *bt_modul_hc05::get_modul_state()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+STATE?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+STATE?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_addr_mode()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+CMODE?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+CMODE?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::get_fixed_addr()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+BIND?\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+BIND?\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::set_modul_role(ROLE role)
{

    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+ROLE=%i\r\n", (char*)role);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+ROLE=%i\r\n", (char*)role);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::set_device_class(int dclass)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+CLASS=%i\r\n", (char*) dclass);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+CLASS=%i\r\n", (char*) dclass);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::set_modul_giac(char *giac)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+IAC=%s\r\n", giac);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+IAC=%s\r\n", giac);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::set_modul_pincode(char *pin)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+PSWD=%s\r\n", pin);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+PSWD=%s\r\n", pin);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::set_modul_inquiry(char *inqparams)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+INQM=%s\r\n", inqparams);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+INQM=%s\r\n", inqparams);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::set_modul_inqc()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+INQC\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+INQC\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::set_modul_name(char *name)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+NAME=%s\r\n", name);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+NAME=%s\r\n", name);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}

char *bt_modul_hc05::set_modul_uart(char *uartparams)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+UART=%s\r\n", uartparams);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+UART=%s\r\n", uartparams);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}


char *bt_modul_hc05::set_addr_fixed(char *address)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+BIND=%s\r\n", address);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+BIND=%s\r\n", address);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;

}


char *bt_modul_hc05::set_addr_mode(CMODE mode)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+CMODE=%i\r\n", (char*)mode);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(600);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+CMODE=%i\r\n", (char*)mode);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(600);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}

char *bt_modul_hc05::search_device(char *address)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+FSAD=%s\r\n", address);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+FSAD=%s\r\n", address);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}

char *bt_modul_hc05::set_device_paired(char *address, int timeout)
{
    switch(t_uart)  {
        case UART1 :
            sprintf("%c,%d", address, timeout);
            at0.at_send("AT+PAIR=%s\r\n", address);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            sprintf("%c,%d", address, timeout);
            at1.at_send1("AT+FSAD=%s\r\n", address);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}


char *bt_modul_hc05::delete_device(char *address)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+PMSAD=%s\r\n", address);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+PMSAD=%s\r\n", address);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}

char *bt_modul_hc05::delete_all()
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+RMAAD\r\n", "");
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+RMAAD\r\n", "");
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}

char *bt_modul_hc05::connect_device(char *address)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+LINK=%s\r\n", address);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+LINK=%s\r\n", address);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}

char *bt_modul_hc05::disconnect_device(char *address)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("AT+DISC=%s\r\n", address);
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            at1.at_send1("AT+DISC=%s\r\n", address);
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }

    }
    return 0;
}

bool bt_modul_hc05::data_send(char *data)
{
    switch(t_uart)  {
        case UART1 :
            at0.at_send("%s\r\n", data);
            return true;
        case UART6 :
            at1.at_send1("%s\r\n", data);
            return true;
    }
    return false;
}

char *bt_modul_hc05::data_receive()
{
    switch(t_uart)  {
        case UART1 :
            if(t_interrupt == OFF)  {
                return at0.getAnswer(800);
            } else  {
                return at0.buffer;
            }

        case UART6 :
            if(t_interrupt1 == OFF)  {
                return at1.getAnswer(800);
            } else  {
                return at1.buffer;
            }
    }
    return '\0';

}

void bt_modul_hc05::flush()
{
    switch(t_uart)  {
        case UART1 :
            if(t_interrupt == ON)  {
                at0.clear();
            }

        case UART6 :
            if(t_interrupt1 == ON)  {
                at1.clear();
            }
    }
}

char *bt_modul_hc05::search_device()
{
    bt_modul_hc05::set_addr_mode(ANY);
    bt_modul_hc05::get_modul_init();
    bt_modul_hc05::set_modul_giac("9e8b33");
    bt_modul_hc05::set_device_class(0);
    bt_modul_hc05::set_modul_inquiry("1,8,24");
    return bt_modul_hc05::get_modul_inqm();
}

char *bt_modul_hc05::link_device_any(char *address)
{
    bt_modul_hc05::set_addr_mode(ANY);
    bt_modul_hc05::search_device(address);
    return bt_modul_hc05::connect_device(address);

}

char *bt_modul_hc05::link_device_fixed(char *address)
{

    bt_modul_hc05::set_addr_mode(FIXED);
    bt_modul_hc05::set_addr_fixed(address);
    return bt_modul_hc05::connect_device(address);

}

char *bt_modul_hc05::link_device_paired(char *address)
{
    bt_modul_hc05::set_addr_mode(ANY);
    bt_modul_hc05::get_modul_init();
    bt_modul_hc05::set_device_paired(address, 10);
    return bt_modul_hc05::connect_device(address);

}

void bt_modul_hc05::init_master_fixed(char *address)
{
    bt_modul_hc05::set_modul_role(MASTER);
    bt_modul_hc05::link_device_fixed(address);
    bt_modul_hc05::set_reset();
}

void bt_modul_hc05::init_slave()
{
    bt_modul_hc05::set_addr_mode(ANY);
    bt_modul_hc05::set_modul_role(SLAVE);
    bt_modul_hc05::set_reset(); 
}