
#include "mbed.h"
#include "at.h"
#include "hc05.h"
#include "stdio.h"
#include "math.h"

bt_modul_hc05 hc05;

DigitalOut led1(LED1);
AnalogIn ad(PA_1);
char *receive;
char buff[32];
float volt = 0.00;

void menu();
void getInfo();
void options();

int main()
{
    pc.terminal_init(38400, ON);
    hc05.initUART(UART6, 38400, OFF);
    wait(1.0);

    pc.pc_send("\r\nInfo: please type '?' for menue options\r\n", "");

    while(1)  {

        char *data = hc05.data_receive();
        
        if(strlen(data) != 0)  {
                                               
            if(strncmp(data, "AD0", 3) == 0)  {
                pc.pc_send("Data received!: %s\r\n", data);
                volt = ad.read();
                sprintf(buff, "The voltage is: %f", volt); 
                hc05.data_send(buff);
            }
                    
        }
        menu();

    }
}

void menu()
{
    if(strncmp(pc.buffer, "pin", 3) == 0)  {
        pc.pc_send("set pin: %s", hc05.set_modul_pincode(pc.buffer + 4));
    }

    else if(strncmp(pc.buffer, "name", 4) == 0)  {
        pc.pc_send("set name: %s", hc05.set_modul_name(pc.buffer + 5));
    }

    else if(strncmp(pc.buffer, "role", 4) == 0)  {

        if(strcmp(pc.buffer + 5, "1") == 0)  {
            pc.pc_send("state role: %s", hc05.set_modul_role(MASTER));
        } else if(strcmp(pc.buffer + 5, "0") == 0)  {
            pc.pc_send("state role: %s", hc05.set_modul_role(SLAVE));
        } else  {
            pc.pc_send("can't change value!!\r\n", "");
        }

    }

    else if(strncmp(pc.buffer, "uart", 4) == 0)  {
        pc.pc_send("set uart: %s", hc05.set_modul_uart(pc.buffer + 5));
    }

    else if(strncmp(pc.buffer, "connect", 7) == 0)  {
        pc.pc_send("connect fixed: %s", hc05.link_device_fixed(pc.buffer + 8));
    }


    else if(strncmp(pc.buffer, "mastermode", 10) == 0)  {
        hc05.init_master_fixed(pc.buffer + 11);
        pc.pc_send("master init OK\r\n", "");
    }

    else if(strncmp(pc.buffer, "slavemode", 9) == 0)  {
        hc05.init_slave();
        pc.pc_send("slave init OK\r\n", "");
    }

    else if(strcmp(pc.buffer, "info") == 0)  {
        getInfo();
    }

    else if(strcmp(pc.buffer, "search") == 0)  {
        pc.pc_send("%s", "CMD:ADDR0:ADDR1:ADDR2,CLASS,RSSI\r\n");
        pc.pc_send("%s", hc05.search_device());
    }

    else if(strcmp(pc.buffer, "end search") == 0)  {
        pc.pc_send("end search: %s", hc05.set_modul_inqc());
    }

    else if(strncmp(pc.buffer, "send", 4) == 0)  {
        hc05.data_send(pc.buffer + 4);
        pc.pc_send("Data send\r\n", "");
    }

    else if(strcmp(pc.buffer, "?") == 0)  {
        options();
    }



    pc.clear();
}

void getInfo()
{
    pc.pc_send("state: %s\r\n", hc05.get_modul_state());
    pc.pc_send("own address: %s\r\n", hc05.get_modul_address());
    pc.pc_send("fixed address: %s", hc05.get_fixed_addr());
    pc.pc_send("name is: %s\r\n", hc05.get_modul_name());
    pc.pc_send("pin is: %s\r\n", hc05.get_modul_pincode());
    pc.pc_send("role is: %s\r\n", hc05.get_modul_role());
    pc.pc_send("uart settings are: %s\r\n", hc05.get_modul_uart());
}

void options()
{
    pc.pc_send("\r\n*********  Menu  ***********************************\r\n\r\n", "");
    pc.pc_send("Set to Pincode         type in 'pin xxxx'\r\n", "");
    pc.pc_send("Set to Name            type in 'name xx...'\r\n", "");
    pc.pc_send("Set to Role            type in 'role 0, 1 or 2'\r\n", "");
    pc.pc_send("Set to UART            type in 'uart baud, startbit, parity'\r\n", "");
    pc.pc_send("Connect to fixed addr  type in 'connect XX..,XX..,XX..'\r\n", "");
    pc.pc_send("Set to Mastermode      type in 'mastermode fixed address'\r\n", "");
    pc.pc_send("Set to slavemode       type in 'slavemode'\r\n", "");
    pc.pc_send("Info Modul settings    type in 'info'\r\n", "");
    pc.pc_send("Search other BT-Moduls type in 'search'\r\n", "");
    pc.pc_send("Cancel search          type in 'end search'\r\n", "");
    pc.pc_send("Send Data to Connected type in 'send Strings'\r\n", "");
    pc.pc_send("Display this Menue     type in '?'\r\n", "");
    pc.pc_send("\r\n********* End Menu  ********************************\r\n", "");
}
