#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"
#include <algorithm>    // std::max


#define CHANNELON   0
#define CHANNELOFF  1
#define LCDLEN      10
#define DATATIME    0.1
//LCD messages



// Operating parameters
#define SIDETONE    700.0
#define TONEMIN     200.0
#define TONEINT     800.00 // So tone max is 1000
#define TONEON      0.50
#define TONEOFF     0.0
#define SPEEDAST    0
#define TONEAST     1

SLCD slcd; //define LCD display

TSISensor tsiScaling; // Capacitive sensor/slider

AnalogIn analogRand(PTB3);
PwmOut led(LED_RED);
DigitalOut outPin(PTC9); //J1-16
PwmOut soundOut(PTA13);
Serial pc(USBTX, USBRX);

// Global scalars
char lcdData[LCDLEN];

float tonePeriod;
float toneFreq = SIDETONE;



void LCDMessNoDwell(char *lMess)
{
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}

void toneAdjust( float scaling)
{
    int tempInt;

    toneFreq = TONEMIN + scaling * TONEINT;
    tonePeriod = 1.0/toneFreq;
    soundOut.period(tonePeriod); // adusting period
    tempInt = (int)toneFreq;
    sprintf (lcdData,"%4d",tempInt);
    LCDMessNoDwell(lcdData);
    return;
}
void lightAdjust( float scaling)   // Control brightness of LED
{
    float tempDutyFactor;
    tempDutyFactor = 1.0 - scaling; //LED is a sinking connection
    // anode is held at 5V
    led.write(tempDutyFactor); //sdjusting duty factor
    return;
}
int main()
{
    int tempInt;
    float tempValue;
    float analogValue;
    float mx = 0;
    float mn = 1;
    float previousDelta = 0;
    float delta = 0;

    tonePeriod = 1.0/toneFreq;
    soundOut.period(tonePeriod);

    led.write(CHANNELON);
    outPin.write(CHANNELOFF);
    tempInt = (int)toneFreq;
    sprintf (lcdData,"%4d",tempInt);
    LCDMessNoDwell(lcdData);
    wait(DATATIME);
    while (true) {

        tempValue = tsiScaling.readPercentage();
        for (int i = 0; i < 100; ++i) {
            analogValue = analogRand.read();
            mx = max(mx, analogValue);
            mn = min(mn, analogValue);


            //mn =  mn > analogValue ? analogValue : mn;
//            mx = mx < analogValue ? analogValue : mx;
            //if (analogValue > mx){
//                mx = analogValue;
//            }
//            if (analogValue < mn){
//                mn = analogValue;
//            }

        }
        delta = mx - mn;

        pc.printf("%f    %f    %f    %f \n", analogValue, mn, mx, delta);
        wait_ms(DATATIME);
        if(previousDelta !=  delta) {
            soundOut.write(TONEON); // set duty factor to 505
            toneAdjust( analogValue);
            lightAdjust(analogValue);
            previousDelta = delta;
        } else {
            soundOut.write(TONEOFF); // set dutyfactor to 0%
            LCDMessNoDwell("SOFF");
        }
        wait(DATATIME);
    } // while forever
}// end main