/* 
Rahul Patle
Midterm - KL46Z Orientation Sensor program
Test of the accelerometer, digital I/O, on-board LCD screen.
 */

#include "mbed.h"
#include "MMA8451Q.h"
#include "SLCD.h"
#include "math.h"

// Configure Accelerometer/Magnetometer: 
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
  PinName const SCL = PTE24;  // DO NOT CHANGE
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

#define PI 3.14159265
#define DATATIME 0.150
#define PROGNAME "ACCLCD341VB\r/n"
#define PRINTDBUG
#define LEDON false
#define LEDOFF true
#define LCDLEN 10
#define LOWPOINT 0.05
#define LOWLIMIT 0.150
#define HILIMIT 1.10
#define ONTIME 1.0
#define BLINKTIME 0.01// milliseconds


enum orientStates {INTERMEDIATE, LANDSCAPE, PORTRAIT}; // define the states
PwmOut greenColor(LED_GREEN);
PwmOut redColor(LED_RED);
SLCD slcd; //define LCD display

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);

float sqrt_newt(float argument) {
    int i = 0;
    float xValNew = 0.0;
    int intMax = 20;
    int epsilon = 1e-7;
    float xValOld = float(argument/2.0);
    int delta = 1;
    for(i=0; i<intMax; i++){
        xValNew = 0.5*(xValOld + (argument/xValOld));
        delta = abs(xValNew-xValOld);
        if (delta < epsilon)
            break;
        else
            xValOld = xValNew;
    }
    return xValOld;
    
//    return (sqrt(argument));
}

// Print using LCD screen
void LCDMess(char *lMess, float dWait){
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
    wait(dWait);
} 


int main() {
    float xAcc;
    float yAcc;
    float vector;
    float angle;  
    char lcdData[LCDLEN]; //buffer needs places dor decimal pt and colon
    orientStates PGMState = INTERMEDIATE;    
    Timer LEDTimer;  // time till next PWM values is to change.
    int ledState = LEDON;  
    int timeToChangeDF = BLINKTIME;
    // set up timer for next step of Duty Factor timing
    LEDTimer.start();
    LEDTimer.reset();

    #ifdef PRINTDBUG
        pc.printf(PROGNAME);
    #endif

  // main loop forever 
  while(true) {
    switch (PGMState){ 
            case INTERMEDIATE: 
                //Get accelerometer data - tilt angles minus offset for zero mark.
                xAcc = abs(acc.getAccX());
                yAcc = abs(acc.getAccY()); 
                
                // Calulate vector sum and angle of x and y reading.       
                vector = sqrt_newt(pow(xAcc,2) + pow(yAcc,2));
                angle = atan(yAcc / xAcc)* 180 / PI;
                
                
                #ifdef PRINTDBUG
                   pc.printf("xAcc = %f\r\n", xAcc);
                   pc.printf("yAcc = %f\r\n", yAcc);
                   pc.printf("vector = %f\r\n",  vector);
                   pc.printf("Angle = %f\r\n",  angle);
                #endif                 
                sprintf (lcdData,"%4.3f", yAcc);
                LCDMess(lcdData, DATATIME);
                                
                
                // Define the landscape and portrait position using x and y readings
                if(yAcc < LOWLIMIT && xAcc > LOWPOINT && xAcc < HILIMIT){
                    PGMState = PORTRAIT;
                } else if (xAcc < LOWLIMIT && yAcc > LOWPOINT && yAcc < HILIMIT){
                    PGMState = LANDSCAPE;
                } else {                     
                     // Blink the LED if in this state
                     ledState = ! ledState;
                     if (LEDTimer.read_ms() > timeToChangeDF){ //Check for timer for transition
                        redColor.write(ledState);
                        greenColor.write(ledState);
                        LEDTimer.reset();
                        PGMState = INTERMEDIATE;
                     }                                          
                } 
                break;
              
             case PORTRAIT:   
                // Green LED is ON and Red is OFF            
                redColor.write(LEDON);
                greenColor.write(LEDOFF);               
                PGMState = INTERMEDIATE;  //Idle state
                break;
              
             case LANDSCAPE:  
                // Green LED is OFF and Red is ON
                redColor.write(LEDOFF);
                greenColor.write(LEDON);                                
                PGMState = INTERMEDIATE;  //Idle state
                break;
                
            default:
                PGMState = INTERMEDIATE;  //Idle state
                break;
              
        } // End state machine
    }
}