#include "mbed.h"
#include "MMA8451Q8g.h"
#include "SLCD.h"

#define BLINKTIME   0.7
#define RELAYON     0
#define RELAYOFF    1
#define LEDDELAY    0.75
#define WAITDELAY   0.7
#define LCDLEN      10

#define REG_WHO_AM_I      0x0D
#define XYZ_DATA_CFG      0x0E

#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05
#define REG_PULSE_SRC     0x22
#define REG_PULSE_CFG     0x21

#define REG_PULSE_SRC     0x22
#define REG_PULSE_THSZ    0x25// REGISTER to activate INTERRUPT WHEN Z IS TAPPED
#define REG_CTRL_4        0x2D
#define REG_CTRL_5        0x2E

#define MAX_2G            0x00
#define MAX_4G            0x01
#define MAX_8G            0x02

#define SET_INTERRUPT     0x08
#define SET_INT_LINE      0x08

//#define PRINTDBUG
// Accelerometer SPI pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#else
#error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

Ticker ledBlink; // timinginterrupt for RED led
//InterruptIn mybutton(PTC3);  //push botton with internal pullup
InterruptIn mybutton(PTC5);  //tap button with internal pullup accelererometer action Interrupt

DigitalOut myled(LED_RED); // red led
DigitalOut relay(LED_GREEN); // green led

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

float delay = WAITDELAY;
int relayState = RELAYOFF;
int outState = false;
SLCD slcd; //define LCD display
char LCDMessages[2][LCDLEN] = {"TRUE", "FALS"};


void LCDMess(char *lMess, float dWait)
{
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
    wait(dWait);
}
void LCDMessNoDwell(char *lMess)
{
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}


void LEDBlinker()   // RED LED interrupt
{
    outState = !outState;
    myled.write(outState);
}

void GreenLEDBlinker()   // GREEN LED interrupt
{
    relayState = !relayState;
    relay.write(relayState);
}



void pressed() // button intterupt
{
    relayState = !relayState;
    relay.write(relayState);
}

int main()
{
    uint8_t regData = MAX_4G;
    uint8_t latchData = 0x40; //0b01000000; //for pulse config register
    uint8_t axisData = 0x10; //0b00010000;
    char lcdData[LCDLEN];

    myled.write(outState);
    relay.write(relayState);

//// set up interrrupts to be used later for taps
//    mybutton.fall(&pressed);

    // set up interrrupts to be used later for taps
    mybutton.rise(&GreenLEDBlinker);
    mybutton.mode(PullNone);

// set up interrrupts to be used later for taps
    ledBlink.attach(&LEDBlinker, LEDDELAY);

// Check to see if accerlometer is alive and well
    acc.setGLimit(MAX_2G); // For now set to 2g
    acc.readRegs(XYZ_DATA_CFG, &regData, 1);
    sprintf (lcdData,"%x",regData); // Note displaying in hexidecimal
    LCDMess(lcdData,BLINKTIME);

    // Set up (pulse) interrupt to INT1 pin
    acc.setRegisterInStandby(REG_CTRL_4, SET_INTERRUPT); // write the data
    acc.setRegisterInStandby(REG_CTRL_5, SET_INT_LINE); // write the data

    acc.readRegs(REG_WHO_AM_I, &regData, 1);
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME);

    // Read Pulse Source Data and check to see if things have been set
    acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME);

    regData = latchData | axisData;
    acc.setRegisterInStandby(REG_PULSE_CFG, regData); // write the data
    acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME);

    while (true) {

        acc.readRegs(REG_PULSE_SRC, &regData, 1);
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME);

        LCDMessNoDwell(LCDMessages[relayState]);
        wait(delay);
    }
}
