#include "mbed.h"

Serial pc(USBTX, USBRX);

AnalogIn   vrefint1(PA_3);
AnalogIn   vrefint2(PC_0);
AnalogIn   vrefint3(PC_3);
AnalogIn   vrefint4(PF_3);
AnalogIn   vrefint5(PF_5);
AnalogIn   vrefint6(PF_10);
AnalogIn   vrefint7(PB_1);
AnalogIn   vrefint8(PA_6);

DigitalOut Buzzer(PA_5);

DigitalOut led1(PF_15);
DigitalOut led2(PE_13);
DigitalOut led3(PF_14);
DigitalOut led4(PE_11);
DigitalOut led5(PE_9);
DigitalOut led6(PF_13);
DigitalOut led7(PF_12);
DigitalOut led8(PD_15);



int main() 
{
    Buzzer = 0;
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    led5 = 0;
    led6 = 0;
    led7 = 0;
    led8 = 0;

    float val1, val2, val3, val4, val5, val6, val7, val8;
      
    float Volts1, Volts2, Volts3, Volts4, Volts5, Volts6, Volts7, Volts8;
    
    float temp1, temp2, temp3, temp4, temp5, temp6, temp7, temp8;
    
    float tempC1, tempC2, tempC3, tempC4, tempC5, tempC6, tempC7, tempC8;
    
    float avg1[50], avg2[50], avg3[50], avg4[50], avg5[50], avg6[50], avg7[50], avg8[50];
    
    float totalavg1, totalavg2, totalavg3, totalavg4, totalavg5, totalavg6, totalavg7, totalavg8 = 0.0;
    
    float Rx;
    
    //for 3v
    //float C = -74.26;
    
    //for 5v
    float C = 106.85;
    
    //for 3.3v
    //float slope = 167.03;
    
        
    //for 5v
    float slope = 48.31;
    
    //for sensor supply 5v adc reff 3.3v 1) 1.10 for 30 deg c 2) 0.09 fpr 30deg c
    //float C = 110.42;
    //float C = 88.9;
    //float slope = 14.21;
    //float slope = 20.73;
    
    
    
    float calibration;
    
    float R0 = 100.0;
    
    float alpha = 0.00385;
    
    float tempTh = 26;
            
    while(true) 
    {
        
        for(int i=0; i < 50; i++)
        {
            val1 = vrefint1.read_u16();
             //pc.printf("%3.2f",val1);       
            //Volts1 = (val1/65536)*3.3;
            Volts1 = (val1/65536)*3.3;
            Rx = Volts1*slope+C;
            temp1= (Rx/R0-1.0)/alpha;
            calibration=0.3+(0.005*temp1);
            tempC1=temp1-calibration;
            avg1[i]=tempC1;
            
            val2 = vrefint2.read_u16();
                    
            Volts2 = (val2/65536)*3.3;
            Rx = Volts2*slope+C;
            temp2= (Rx/R0-1.0)/alpha;
            calibration=0.3+(0.005*temp2);
            tempC2=temp2-calibration;
            avg2[i]=tempC2;
            
            val3 = vrefint3.read_u16();
                    
            Volts3 = (val3/65536)*3.3;
            Rx = Volts3*slope+C;
            temp3= (Rx/R0-1.0)/alpha;
            calibration=0.3+(0.005*temp3);
            tempC3=temp3-calibration;
            avg3[i]=tempC3;
            
            val4 = vrefint4.read_u16();
                    
            Volts4 = (val4/65536)*3.3;
            Rx = Volts4*slope+C;
            temp4= (Rx/R0-1.0)/alpha;
            calibration=0.3+(0.005*temp4);
            tempC4=temp4-calibration;
            avg4[i]=tempC4;
            
            val5 = vrefint5.read_u16();
                    
            Volts5 = (val5/65536)*3.3;
            Rx = Volts5*slope+C;
            temp5= (Rx/R0-1.0)/alpha;
            calibration=0.3+(0.005*temp5);
            tempC5=temp5-calibration;
            avg5[i]=tempC5;
            
            val6 = vrefint6.read_u16();
                    
            Volts6 = (val6/65536)*3.3;
            Rx = Volts6*slope+C;
            temp6= (Rx/R0-1.0)/alpha;
            calibration=0.3+(0.005*temp6);
            tempC6=temp6-calibration;
            avg6[i]=tempC6;
            
            val7 = vrefint7.read_u16();
                    
            Volts7 = (val7/65536)*3.3;
            Rx = Volts7*slope+C;
            temp7= (Rx/R0-1.0)/alpha;
            calibration=0.3+(0.005*temp7);
            tempC7=temp7-calibration;
            avg7[i]=tempC7;
            
            val8 = vrefint8.read_u16();
                    
            Volts8 = (val8/65536)*3.3;
            Rx = Volts8*slope+C;
            temp8= (Rx/R0-1.0)/alpha;
            calibration=0.3+(0.005*temp8);
            tempC8=temp8-calibration;
            avg8[i]=tempC8;
        
            wait(0.02);
        }
        
        for(int j=0; j < 50; j++)
        {
          totalavg1 =  totalavg1 + avg1[j];
          totalavg2 =  totalavg2 + avg2[j];
          totalavg3 =  totalavg3 + avg3[j];
          totalavg4 =  totalavg4 + avg4[j];
          totalavg5 =  totalavg5 + avg5[j];
          totalavg6 =  totalavg6 + avg6[j];
          totalavg7 =  totalavg7 + avg7[j];
          totalavg8 =  totalavg8 + avg8[j];
          wait(0.01);
        }
        totalavg1 = (int)totalavg1/50;
        totalavg2 = (int)totalavg2/50;
        totalavg3 = (int)totalavg3/50;
        totalavg4 = (int)totalavg4/50;
        totalavg5 = (int)totalavg5/50;
        totalavg6 = (int)totalavg6/50;
        totalavg7 = (int)totalavg7/50;
        totalavg8 = (int)totalavg8/50;
        
        totalavg1 -= 6;
        totalavg2 -= 2;
        totalavg3 -= 7;
        totalavg4 -= 2;
        totalavg5 -= 2;
        totalavg6 -= 2;
        totalavg7 -= 2;
        totalavg8 -= 2;
        
        pc.printf("%3.2f    %3.2f   %3.2f   %3.2f   %3.2f   %3.2f   %3.2f   %3.2f\n", totalavg1, totalavg2, totalavg3, totalavg4, totalavg5, totalavg6, totalavg7, totalavg8);
        
        if((totalavg1 >= tempTh && totalavg1 < 100 ) || (totalavg2 >= tempTh && totalavg2 < 100 ) || (totalavg3 >= tempTh && totalavg3 < 100 ) || (totalavg4 >= tempTh && totalavg4 < 100)  || (totalavg5 >= tempTh && totalavg5 < 100 ) || (totalavg6 >= tempTh && totalavg6 < 100)  || (totalavg7 >= tempTh && totalavg7 < 100 ) || (totalavg8 >= tempTh && totalavg8 < 100 ))
            Buzzer = 1;
           
        else
            Buzzer = 0;
            
        
        if((totalavg1 >= tempTh) && (totalavg1 < 100))
        {
            led1 = 1;
            //pc.printf("Relay 1 is ON\n");
            }
        else
        {
            led1 = 0;
            //pc.printf("Relay 1 is OFF\n");
            }
        totalavg1 = 0;
            
        if((totalavg2 >= tempTh) && (totalavg2 < 100))
            led2 = 1;
        else
            led2 = 0;
        totalavg2 = 0;
            
        if((totalavg3 >= tempTh) && (totalavg3 < 100))
            led3 = 1;
        else
            led3 = 0;
        totalavg3 = 0;
            
        if((totalavg4 >= tempTh) && (totalavg4 < 100))
            led4 = 1;
        else
            led4 = 0;
        totalavg4 = 0;
            
        if((totalavg5 >= tempTh) && (totalavg5 < 100))
            led5 = 1;
        else
            led5 = 0;
        totalavg5 = 0;
        
        if((totalavg6 >= tempTh) && (totalavg6 < 100))
            led6 = 1;
        else
            led6 = 0;
        totalavg6 = 0;
            
        if((totalavg7 >= tempTh) && (totalavg7 < 100))
            led7 = 1;
        else
            led7 = 0;
        totalavg7 = 0;
            
        if((totalavg8 >= tempTh) && (totalavg8 < 100))
            led8 = 1;
        else
            led8 = 0;
        totalavg8 = 0;
        
               
        wait(0.5f);
        //totalavg1, totalavg2, totalavg3, totalavg4, totalavg5, totalavg6, totalavg7, totalavg8  = 0.0;
    }
} 