#include "mbed.h"
#include "mbed_events.h"


DigitalOut led1(LED1);
Thread thread;

InterruptIn button1(USER_BUTTON);
volatile bool button1_pressed = false; // Used in the main loop
volatile bool button1_enabled = true; // Used for debouncing
Timeout button1_timeout; // Used for debouncing

// Enables button when bouncing is over
void button1_enabled_cb(void)
{
    button1_enabled = true;
}

// ISR handling button event
void button1_onEvent_cb(void)
{
    if (button1_enabled) { // Should be disabled while the button is bouncing
        button1_enabled = false;
        button1_pressed = true; // To be read by the main loop
        // as commented out the "debuncer is broken"
//        button1_timeout.attach(callback(button1_enabled_cb), 0.3); // Debounce time 300 ms
        button1_enabled_cb();
    }
}

void led_thread()
{
    while (true) {
        if(button1.read()==1) {
            // blink when not_pressed
            printf("blink\r\n");
            led1 = 1; // LED is ON
            Thread::wait(200); //ms
            led1 = 0; // LED is OFF
        }
        Thread::wait(2000); //ms
    }
}

int main()
{
    button1.mode(PullUp); // Activate pull-up
    button1.fall(callback(button1_onEvent_cb)); // Attach ISR to handle button press event
    button1.rise(callback(button1_onEvent_cb)); // Attach ISR to handle button rise event
    Thread thread;
    thread.start(led_thread);

    int idx = 0; // Just for printf below

    while(1) {
        if (button1_pressed) { // Set when button is pressed
            button1_pressed = false;

            if(button1.read()==0) {
                printf("Button pressed  %d\r\n", idx++);
                led1=1; // LED ON
            } else {
                printf("Button released %d\r\n", idx++);
                led1=0; // LED OFF
            }
        }
    }
}
