#include "mbed.h"
#include "MMA8451Q.h"
#include "cmsis.h"
#include "PeripheralPins.h"
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
InterruptIn intin(PTA15);
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);

void sleeep()
{
    SMC->PMPROT = SMC_PMPROT_AVLLS_MASK | SMC_PMPROT_ALLS_MASK | SMC_PMPROT_AVLP_MASK;
 
    //Normal sleep mode for ARM core:
    SCB->SCR = 0;
    __WFI();
}
 
void intfun(){

        uint8_t datan[1]; 
acc.readRegs(0x0C,datan,1);
if((datan[0]&0x04)==0x04){
    acc.readRegs(0x16,datan,1);
        pc.printf("fall_sleep \n\r"); 
        sleeep();
    }
    }

int main(void)
{
    pc.printf("Init \n\r"); 
    
    
    intin.fall(&intfun);
   
    uint8_t krok1[2] = {0x2A, 0x20};
    acc.writeRegs(krok1, 2);
    
    uint8_t krok2[2] = {0x15, 0xB8};
    acc.writeRegs(krok2,2);
    
    uint8_t krok3[2] = {0x17, 0x03};
    acc.writeRegs(krok3,2);
    
    uint8_t krok4[2] = {0x18, 0x06};
    acc.writeRegs(krok4,2);
    
    uint8_t krok5[2] = {0x2D, 0x04};
    acc.writeRegs(krok5,2);
    
    uint8_t krok6[2] = {0x2E, 0x00};
    acc.writeRegs(krok6,2);
    
    
    //krok7
    uint8_t data[1]; 
    acc.readRegs(0x2A,data,1); 
    data[0]=data[0]| 0x01;
    
    uint8_t krok7[2] = {0x2A, data[0]};
    krok7[1] = data[0];
    acc.writeRegs(krok7,2);
    pc.printf("sleep \n\r"); 
    sleeep();
    while (true) {
       
    }
}
