#include "mbed.h"
#include "WS2812.h"
#include <stdio.h>
#include "PixelArray.h"


#define WS2812_BUF 16   //количество светодиодов в матрице 
#define NUM_COLORS 15  //количество цветов
#define PIN_NUM A2    // номер пина 



using namespace std;

PixelArray px(WS2812_BUF); // обращение к объекту класса матрицы
//WS2812 ws(PIN_NUM, WS2812_BUF,6,17,9,14); //обращение к объекту класса светодиодного модуля
WS2812 ws(PIN_NUM, WS2812_BUF,3,12,9,12);


int color_set(uint8_t red,uint8_t green, uint8_t blue) // функция установки цвета 
{
  return ((red<<16) + (green<<8) + blue);   
}

// функция получения градиента 
int interpolate(int startValue, int endValue, int stepNumber, int lastStepNumber)
{
    return (endValue - startValue) * stepNumber / lastStepNumber + startValue;
}

int main()
{    
    uint8_t ir = 0;
    uint8_t ig = 0;
    uint8_t ib = 0;

    
   ws.useII(WS2812::PER_PIXEL); //дает возможность установить яркость
    
    // установка цветов, которыми мы хотим воспользоваться 
    int colorbuf[NUM_COLORS] = {0xff0000,0x00FFFF,0x0000FF,0xFF00FF,0x808080,0x00FF00,
                                0xFF0000,0xFFFFFF,0xFFFF00,0x008080,0xFF0099,0xFFF0F5,
                                0x991199,0x808000,0xFFFFF0};
    
    //получить начальные компоненты RGB для градиента
    size_t c1 = colorbuf[0];
    size_t r1 = (c1 & 0xff0000) >> 16;
    size_t g1 = (c1 & 0x00FFFF) >> 8;
    size_t b1 = (c1 & 0x0000FF);
    
    //получить конечные компоненты RGB для градиента 
    size_t c2 = colorbuf[1];
    size_t r2 = (c2 & 0xFF00FF) >> 16;
    size_t g2 = (c2 & 0x808080) >> 8;
    size_t b2 = (c2 & 0x00FF00);
    
    //получение градиента 
    for (int i = 0; i <= WS2812_BUF; i++)
    {       
        ir = interpolate(r1, r2, i, WS2812_BUF);
        ig = interpolate(g1, g2, i, WS2812_BUF);
        ib = interpolate(b1, b2, i, WS2812_BUF);
        px.Set(i, color_set(ir,ig,ib)); // установка для каждого светодиода (i), градиентного цвета(color_set(ir,ig,ib))
      
    }
    
    
    // Цикл плавного крестика
    while(true){ 
    // цикл включения главной диагонали
    for (int x = 0; x<=15; x+=5 ){
            for(int i = 0; i<255; i++){
                px.SetI(x,i); // обращение к светодиоду (x) и установка яркости (i)
                ws.write(px.getBuf()); // вывод на матрицу (запуск)
                }
    }
    //цикл включения побочной диагонали 
    for (int x = 3; x<=12; x+=3 ){
            for(int i = 0; i<255; i++){
                px.SetI(x,i);
                ws.write(px.getBuf());
                }
    }
    // цикл выключения побочной диагонали
    for (int x = 12; x>=3; x-=3 ){
          for(int i = 255; i>=0; i--){  
                px.SetI(x,i);
                ws.write(px.getBuf());
                }
    }
   // цикл выключения главной диагонали 
   for (int x = 15; x>=0; x-=5 ){
          for(int i = 255; i>=0; i--){  
                px.SetI(x,i);
                ws.write(px.getBuf());
                }
    }
        
        
    }
}
