//-------------------------------------------------------------
// file : midi_parser.h
// Copyright (C) 2012 RJB RadioJunkBox
// Released under the MIT License: http://mbed.org/license/mit
//-------------------------------------------------------------

#ifndef MBED_MIDI_PARSER_H
#define MBED_MIDI_PARSER_H

//-------------------------------------------------------------
// Define

#define TRUE                    1
#define FALSE                   0
#define ON                      1
#define OFF                     0

#define MAX_CH                  16
#define MAX_NOTE_CNT            16

// MIDI Massage
#define MIDI_NoteOff            0x80
#define MIDI_NoteOn             0x90
#define MIDI_PolykeyPressure    0xA0
#define MIDI_ControlChange      0xB0
#define MIDI_ProgramChange      0xC0
#define MIDI_ChannelPressure    0xD0
#define MIDI_PitchBend          0xE0

#define MIDI_StartSysEx         0xF0
#define MIDI_TuneRequest        0xF6
#define MIDI_EndSysEx           0xF7

#define MIDI_TimingClock        0xF8
#define MIDI_Start              0xFA
#define MIDI_Continue           0xFB
#define MIDI_Stop               0xFC
#define MIDI_ActiveSensing      0xFE
#define MIDI_SystemReset        0xFF

#define MIDI_CC_Moduration      0x01
#define MIDI_CC_DataEntry       0x06
#define MIDI_CC_RPN_LSB         0x64
#define MIDI_CC_RPN_MSB         0x65

#define MIDI_MM_AllSoundOff     0x78
#define MIDI_MM_ResetAllControl 0x79
#define MIDI_MM_AllNoteOff      0x7B

//-------------------------------------------------------------
// Global variables

unsigned char    gPlayNoteBuf[MAX_CH];
unsigned char    gGateBuf[MAX_CH];
unsigned char    gPitchBendBuf[MAX_CH];
unsigned char    gModWheelBuf[MAX_CH];
unsigned char    gMIDISYNC_CLK;
unsigned char    gMIDISYNC_RUN;

unsigned char    NoteCnt[MAX_CH];
unsigned char    NoteBuf[MAX_CH][MAX_NOTE_CNT];

unsigned char    RxByte;
unsigned char    SysEx;
unsigned char    MidiCh;
unsigned char    PC;
unsigned char    MByte[2];

//-------------------------------------------------------------
// Functions

void MIDI_Parser(unsigned char);
int  MIDI_SystemMessage(void);
void MIDI_SystemRealtimeMessage(void);
void MIDI_ChannelMessage(void);
void NoteON(void);
void NoteOFF(void);

#endif
