// 
// OSC Receiver
//
// date: 2011/1/10
// version: 0.7
// written by: xshige
//
// please find OSC Sender program at the bottom of this file
//
/*
  The followings are supported:

    Transport Type: 
      UDP

    Features: 
     Packet Parsing (Client)
     Not Supported:Packet Construction (Server)
     Bundle NOT Support
     Timetag NOT Support

    Type Support: 
     i: int32
     b: blob
     s: string
     f: float32
     m: MIDI message(port id, status byte, data1, data2) // I don't know the detail
 
*/


#include "mbed.h"
#include "OSCReceiver.h" // Add by RadioJunkBox 2012/05/16 

/* comment out by RadioJunkBox 2012/05/16

#include "EthernetNetIf.h"
#include "UDPSocket.h"

#define DHCP

//#define INPUT_PORT 12000
#define INPUT_PORT 12345

#ifdef DHCP
EthernetNetIf eth;
#else
EthernetNetIf eth(
  IpAddr(192,168,0,25), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,0,1), //Gateway
  IpAddr(192,168,0,1)  //DNS
);
#endif
//--- OSC related stuff ---
union OSCarg {
// char*, int and float are assumed four bytes
        char *address;
        char *typeTag;
        int i;
        float f;
        char *s;
        struct {
            int len; // is "int i"
            char *p;
        } blob;
        char m[4];  // for MIDI
        char _b[4]; // endian conversion temp variable
};
*/
void getOSCmsg(char *packet , union OSCarg *msg){
// Caution: the returned result points to packet as blobs or strings (not newly allocatd)
    char *p, *typeTag; char c;
        
    msg[0].address = packet; // address
    msg[1].typeTag = packet+4*(strlen(msg[0].s)/4+1);//typeTag
    typeTag=msg[1].s+1; // skip ','
    p= msg[1].s+4*(strlen(msg[1].s)/4+1);
    for(int n=0; n<strlen(typeTag); n++){
        c = typeTag[n];
        if (('s'==c)) {
            msg[n+2].s=p;
            p += 4*(strlen(msg[n+2].s)/4+1);
        } else if (('i'==c)||('f'==c)) {
            // chang endian (big to little)
            msg[n+2]._b[3]=p[0]; 
            msg[n+2]._b[2]=p[1]; 
            msg[n+2]._b[1]=p[2];
            msg[n+2]._b[0]=p[3];
            p +=4;  
        } else if ('b'==c) {
            // chang endian (big to little)
            // get lenth of blog (copy to msg[n].blog.len)
            msg[n+2]._b[3]=p[0]; 
            msg[n+2]._b[2]=p[1]; 
            msg[n+2]._b[1]=p[2];
            msg[n+2]._b[0]=p[3];
            p +=4;  
            // get ponter of blog (copy to msg[n].blog.p)
            msg[n+2].blob.p=p;
            p += 4*(msg[n+2].blob.len/4+1);       
        } else if ('m'==c) {
            // get midi data (copy to msg[n].m[])
            msg[n+2].m[0]=p[0]; 
            msg[n+2].m[1]=p[1]; 
            msg[n+2].m[2]=p[2];
            msg[n+2].m[3]=p[3];
            p +=4;  
        } else {
            printf("*** Not Supported TypeTag:%s ****\n",typeTag);
        }
    };
    
}
//-------------------------------------------

/* comment out RadioJunkBox 2012/05/06

UDPSocket udp;


void onUDPSocketEvent(UDPSocketEvent e)
{
  union OSCarg msg[10];

  switch(e)
  {
  case UDPSOCKET_READABLE: //The only event for now
    char buf[256] = {0};
    Host host;
    while( int len = udp.recvfrom( buf, 256, &host ) )
    {
      if( len <= 0 )
        break;
      printf("\r\nFrom %d.%d.%d.%d:\r\n", 
      host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3]);
      
      getOSCmsg(buf,msg);
      // address pattern samples
      if (strcmp(msg[0].address,"/test")==0) {
        printf("OSCmsg: %s %s %d %f %s %d\n", 
            msg[0].address, msg[1].typeTag,msg[2].i, msg[3].f, msg[4].s, msg[5].blob.len);
        printf("blob content:\n");
        char *p=msg[5].blob.p;
        for(int n=0; n<msg[5].blob.len; p++,n++) printf(" %02X",(unsigned char)(*p));
        printf("\n");
        break;
      }
      if (strcmp(msg[0].address,"/kb/m")==0) {
        printf("OSCmsg: %s %s %d %d %d\n", 
            msg[0].address, msg[1].typeTag,msg[2].i, msg[3].i, msg[4].i);
        break;
      }
      if (strcmp(msg[0].address,"/cc/m")==0) {
        printf("OSCmsg: %s %s %d %d %d\n", 
            msg[0].address, msg[1].typeTag,msg[2].i, msg[3].i, msg[4].i);
        break;
      }
      if (strcmp(msg[0].address,"/osc/padx")==0) {
        printf("OSCmsg: %s %s %f\n", 
            msg[0].address, msg[1].typeTag,msg[2].f);
        break;
      }
      if (strcmp(msg[0].address,"/osc/pady")==0) {
        printf("OSCmsg: %s %s %f\n", 
            msg[0].address, msg[1].typeTag, msg[2].f);
        break;
      } 
      if (strcmp(msg[0].address,"/osc/button1")==0) {
        printf("OSCmsg: %s %s %i\n", 
            msg[0].address, msg[1].typeTag, msg[2].i);
        break;
      }
      if (strcmp(msg[0].address,"/osc/button2")==0) {
        printf("OSCmsg: %s %s %i\n", 
            msg[0].address, msg[1].typeTag, msg[2].i);
        break;
      }
      if (strcmp(msg[0].address,"/mouse/dragged")==0) {
        printf("OSCmsg: %s %s %i %i\n", 
            msg[0].address, msg[1].typeTag, msg[2].i, msg[3].i);
        break;
      }
      if (strcmp(msg[0].address,"/mouse/pressed")==0) {
        printf("OSCmsg: %s %s %i %i\n", 
            msg[0].address, msg[1].typeTag, msg[2].i, msg[3].i);
        break;
      }
      if (strcmp(msg[0].address,"/1/xy")==0) {
        printf("OSCmsg: %s %s %f %f %d\n", 
            msg[0].address, msg[1].typeTag, msg[2].f, msg[3].f, msg[4].i);
        break;
      }
      printf("undefined OSCmsg:%s %s\n",msg[0].address, msg[1].typeTag);
    } // while
    break;
  } // case
}

int main() {
// make debug port Fast
//   Serial pc(USBTX, USBRX);
//    pc.baud(9600);
//    pc.baud(115200);
//  pc.baud(230400);

  printf("Setting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\r\n", ethErr);
    return -1;
  }
  printf("Setup OK\r\n");
  

  // port setup
//  Host recHost(IpAddr(192, 168, 0, 7), INPUT_PORT, NULL);
  Host broadcast(IpAddr(eth.getIp()[0], eth.getIp()[1], eth.getIp()[2], 255), INPUT_PORT, NULL);
  udp.setOnEvent(&onUDPSocketEvent);
  udp.bind(broadcast);
  
  Timer tmr;
  tmr.start();
  while(true)
  {
    Net::poll();
    if(tmr.read() > 5)
    {
      tmr.reset();
    }
  }

}
*/