/* SIGNAL USAGES IN RTOS 
What is Signal ?  - Answer : Remember these five points

1) Signals are different from all the other types of kernel object in that they are not autonomous (user need to control or set - No automatioc control like semaphore)
2) signals are associated with tasks/Threads and have no independent existence. 
3) If signals are configured for an application, each task has a set of eight signal flags.

4) Any task can set the signals of another task. Only the owner task can read the signals. 
5) The read is destructive – i.e. the signals are cleared by the process of reading. No other task can read or clear a task’s signals.


In below example there are two threads 1)main thread and 2)Thread that is connected with onBoard_led functions
We set the signal from main thread ,  second thread received the signal and toggle the led state.

Program name : LED BLINKING USING RTOS SIGNAL
PLATFORM : STM NUCLEO 64 L476
Created by : jaydeep shah
email : radhey04ec@gmail.com
*/

/* NOTE : WE ARE GOING TO USE EVENT FLAG CLASS METHOD The EventFlags class is used to control event flags or wait for event flags other threads control.
*/
#include "mbed.h"
#include "rtos.h"
 
DigitalOut led(LED2);  //ON BOARD LED
 
EventFlags event_flags;  // EVESNT FLAG OBJECT CREATED (DOMAIN : SIGNAL)

//TASK which is related to signal 
void onBoard_led() {
    uint32_t read = 0;  //CREATE VARIABLE TO STORE DATA
    while (true) {
        // Signal flags that are reported as event are automatically cleared -Autonomous object of Kernal
        
        read = event_flags.wait_any(0x1 | 0x2);
        if(read == 0x1)
        {
        led = !led;  //Toggle state
        }
        printf("\n Received this flag event 0x%08lx \n\r",read);
        
    }
}
 
int main (void) {
    Thread thread;  //create threaed
 
    thread.start(callback(onBoard_led));  //Thread start
 
    while (true) {
        ThisThread::sleep_for(1000); //sleep for 1 sec
        event_flags.set(0x1);  //set the signal for thread task from main thread  --LED BLINK TASK
        ThisThread::sleep_for(1000);
        event_flags.set(0x2); //This signal for print the statement -- use serial terminal
    }
}