//UART - SERIAL INTERRUPT ADVANCE PART

//READ DATA FROM SLAVE DEVICE USING UART PORT

/* NOTE *****************************************************************

If you use normal Serial object than you can face problems of Mutex lock when using Interrupt Handller

That leads to crash on board OS, and you can see the error message on Terminal 

Instead of Serial use --> Rawserial object , so you will not face any problems when using IRQ handler

*******************************************************************   */

/*  About Program : --------------------------------------------------------
Slave board providing data with different Baud rate -57600
PC connected with STM Nucleo with 9600 Baud rate
STM CONNECTED WITH PC AND SLAVE With UART Port
----------------------------------------------------------------------------- */

/* CREATOR  ---
CREATED BY : JAYDEEP SHAH
SUBJECT : RECEIVE DATA USING UART IRQ
radhey04ec@gmail.com
------   */



#include "mbed.h"
#define BUFFER_SIZE 90   //SIZE OF BUFFER   ---DEPENDS ON YOUR DATA SIZE

char rxBuffer[BUFFER_SIZE];  //CREATE CIRCULAR BUFFER  -- TO STORE RECEIVE DATA

unsigned int bufferReadingIndex=0;  //CREATE POINTER TO READ DATA FROM UART AND STORE INTO ARRAY

unsigned int i=0; //counter to read data from buffer Array

// 0 - Rx - PA_0   : Board Tx ___ Arduino Connector socket >>> First_pin _Orange  -- If FTDI CABLE USE
// 1 - Tx - PA_1   : Board Rx ____ Arduino connector socket  >>> Second_pin _red  -- If FTDI CABLE USE

//If you use only Serial calss , there is chance of damage OS because of MUTEX GUARD

//use RawSerial class
RawSerial UT(PA_0,PA_1);  //UART PIN DECLARATION
RawSerial pc(USBTX,USBRX);  //HOST PC TERMINAL  - 9600 BAUD WITH 8-N-1 STTING

//NOTE : UT OBJ FOR SLAVE BOARD & pc OBJ FOR TERMINAL

//DEFINE Rx Interrupt function --DECLARATION
void RxInterrupt(void);

//Function that read response data
void response(void);


int main()
{
UT.baud(57600);  //BAUD RATE SETTING
UT.format(8,Serial::None,1);   //FORMAT OF UART COMMUNICATION

//INTERRUPT ATTACHMENT WHEN RECEIVE DATA
UT.attach(&RxInterrupt,Serial::RxIrq);

pc.printf("\n TESTING TURN ON : \n");
wait(1);

UT.putc('T');  //ENTER IN TEST MODE  -- SLAVE BOARD ENTER INTO TEST MODE
wait(0.5);
response();  //Read Response from Slave 


ThisThread::sleep_for(1000);

UT.putc('d');   // RED LED OF SLAVE BOARD ON
wait(1);
response(); //Read Response from Slave

ThisThread::sleep_for(5000);


UT.putc('b');  // RED LED OF SLAVE BOARD OFF
wait(1);
response();  //Read Response from slave

ThisThread::sleep_for(1000);

UT.putc('Q');  //QUIT FROM TEST MODE -- NORMAL MODE SELECT
wait(1);
response();//Read response from Slave

ThisThread::sleep_for(3000);

while(1)
{
}

}


void RxInterrupt()      //if Rx buffer have data --- Interrupt call
{
    if(UT.readable())  //IF data available
    {
        rxBuffer[bufferReadingIndex++] = UT.getc();   // read and store into Buffer
        if(bufferReadingIndex >= BUFFER_SIZE)  // If limit cross
        {
            bufferReadingIndex =0; // RESET CONTER
        }
    }
}

void response()  //FUNCTION TO READ DATA
{
    char rxByte;

    while(i != bufferReadingIndex)  //READ WHILE COMPLETE DATA NOT RECEIVED
    {
        rxByte = rxBuffer[i];  //READ DATA ONE BY ONE CHARACTER
        pc.putc(rxByte); // SEND ON TERMINAL
        i++;  //COUNTER INCREMENT
        
        if(i >= BUFFER_SIZE) //IF LIMIT CROSS
        {
            i = 0;   //RESET COUNTER
        }
    }
//NO NEED TO USE BELOW DATA LOGIC   
//i = 0;
//bufferReadingIndex = 0;
}
        