/* ADC TUTORIAL BASIC PART-1
NOTE : CLASS --> AnalogIn
Object return value between 0 to 1
If 5 V system and you try to read 2.5 V from ADC PIN than OP = 0.5
PLEASE NOTE : MBED USE 3.3 Vref
*/

//PROGRAM_CREATED BY :  -- radhey04ec@gmail.com
//Hardware : STM32-NUCLEO-64
//MBED : OS PLATFORM


//This program is dedicated to 
// INA-225 TEXAS INSTRUMENT BOARDS TO AMPLIFY LOW VOLTAGE SIGNAL WITH GAIN 200
//SHUNT RESISTOR = 0.6 Ohm
//Vref : 3.3 
// I (current) = ((((ADC O/P - Offset)) * 3.3) *200 ) / 0.6) * 1000      mA


#include "mbed.h"

AnalogIn ANG(PC_3); //Port pin PC_3 last pin for ADC -- Create object

int main()
{
    float AARAY[10],SUM=0;
    
    while(1)
    {
        for(int i =0;i <10 ; i++)  //Array to make result smoother
        {
            AARAY[i] = ANG.read();  //Read the data
            ThisThread::sleep_for(20);  //Thread sleep for make ADC ready for next result
            SUM = SUM + AARAY[i]; //Store result
            } 
        float value = (SUM /10);  //Finding Average value 
        
        float current = (((((((value)) * 3.3)-0.28)/200)/0.6)*1000);  //Finding current
        
        printf("\n Current (mA) = %f",current);  //Print data on Serial console -- I used CoolTerm
        
        ThisThread::sleep_for(250); //Thread sleep 
        
        SUM = 0;  //At the end sum must be zero
}
}