/* LCD INTERFACING ADVANCE PART2  -- TEXT DISPLAY

NOTE : AGAIN YOU NEED TO IMPORT TEXTLCD.H LIBRARY FOR USING LCD INTERFACING FUNCTIONS

NOTE : ALL THE CONNECTION FROM ARDUINO SOCKET INTERFACE (YOU CAN USE ANY)
D4 TO D7 = PA3,PA2,PA10,PB3    === PORT PINS ====
RS = PC0
E = PC1
R/W = GND

PLATFORM :MBED ARM ONLINE
HARDWARE : NUCLEO-64 / STM32\
LCD : 20 *4 DISPLAY   MODULE RG2004A

CREATED BY :JAYDEEP SHAH -- radhey04ec@gmail.com
*/

//NOTE YOU NEED TO IMPORT LIBRARY - TextLCD.h for using class  (4-bit interface)

//Link : https://os.mbed.com/components/HD44780-Text-LCD/

/* LCD PANNEL SUPPORT -- CHANGE ACCORDING IN TextLCD object
Credit goes to : Simon Ford  //CREATOR OF THIS LIBRARY 
TextLCD::LCD16x2     16x2 LCD panel (default) 
TextLCD::LCD16x2B    16x2 LCD panel alternate addressing 
TextLCD::LCD20x2     20x2 LCD panel 
TextLCD::LCD20x4     20x4 LCD panel
TextLCD::LCD8x1    8x1 LCD panel
TextLCD::LCD8x2    8x2 LCD panel
TextLCD::LCD16x1  16x1 LCD panel
TextLCD::LCD16x4  16x4 LCD panel
TextLCD::LCD24x2  24x2 LCD panel
TextLCD::LCD24x4  24x4 LCD panel (for KS0078 controller)
TextLCD::LCD40x2  40x2 LCD panel
TextLCD::LCD40x4  40x4 LCD panel (two controllers)
*/


/* AVAILABLE FUNCTIONS & IT'S USE CASE

1) TextLCD -- class need to create object first
Object contains RS,E,D4-D7 Data pins related information + LCD panel size (Default : 16 *2 )


2)obj_name.cls() : For clear the LCD Display

3)obj_name.printf("")  : Print the data on LCD Display

4)obj_name.locate(Column ,ROW) : Set Cursor on different position

For more -- Try to fatch .cpp and .h file of TextLCD library

*/


#include "mbed.h"  //MBED LIBRARY
#include "TextLCD.h"  // LCD LIBRARY
 
TextLCD lcd(PC_0, PC_1, PB_4, PB_5, PB_3, PA_10, TextLCD::LCD20x4); // rs, e, d4-d7  -- REGISTER SELECT / ENABLE / AND DATA-PIN
 
int main() {  // MAIN THREAD START

    lcd.printf("Jaydeep Shah!\n");  // PRINT COMMAND -- TXT ON LCD
    
    lcd.locate(0,1);  //CURSOR RELOCATE
    
    lcd.printf("KEPL!\n");  //LCD_PRINT
    
    ThisThread::sleep_for(8000);  //8-SEC DELAY  -- THREAD SLEEP FOR 8 SEC
    
    lcd.cls();  // CLEAR THE LCD DISPLAY
}