/* LCD INTERFACING BASIC PART  -- TEXT DISPLAY
D4 TO D7 = PA3,PA2,PA10,PB3    === PORT PINS ====
RS = PC0
E = PC1
R/W = GND
PLATFORM :MBED ARM ONLINE
HARDWARE : NUCLEO-64 / STM32\
LCD : 20 *4 DISPLAY   MODULE RG2004A
JAYDEEP SHAH -- radhey04ec@gmail.com
*/

//NOTE YOU NEED TO IMPORT LIBRARY - TextLCD.h for using class  (4-bit interface)

//Link : https://os.mbed.com/components/HD44780-Text-LCD/

/* LCD PANNEL SUPPORT -- CHANGE ACCORDING IN TextLCD object
Credit goes to : Simon Ford
TextLCD::LCD16x2     16x2 LCD panel (default) 
TextLCD::LCD16x2B    16x2 LCD panel alternate addressing 
TextLCD::LCD20x2     20x2 LCD panel 
TextLCD::LCD20x4     20x4 LCD panel
TextLCD::LCD8x1    8x1 LCD panel
TextLCD::LCD8x2    8x2 LCD panel
TextLCD::LCD16x1  16x1 LCD panel
TextLCD::LCD16x4  16x4 LCD panel
TextLCD::LCD24x2  24x2 LCD panel
TextLCD::LCD24x4  24x4 LCD panel (for KS0078 controller)
TextLCD::LCD40x2  40x2 LCD panel
TextLCD::LCD40x4  40x4 LCD panel (two controllers)
*/

#include "mbed.h"  //MBED LIBRARY
#include "TextLCD.h"  // LCD LIBRARY
 
TextLCD lcd(PC_0, PC_1, PB_4, PB_5, PB_3, PA_10, TextLCD::LCD20x4); // rs, e, d4-d7  -- REGISTER SELECT / ENABLE / AND DATA-PIN
 
int main() {  // MAIN THREAD START

    lcd.printf("Jaydeep Shah!\n");  // PRINT COMMAND -- TXT ON LCD
}