//CALLBACK API USE IN MBED  + FLAG SYSTEM FROM DIFFERENT THREAD
//TARGET : MBED + HARDWARE : NUCLEO-64

//JAYDEEP SHAH -- radhey04ec@gmail.com

//CALLBACK -- IS LIKE FUNCTION CALL BUT MORE USEFUL than normal call.

/* When you created object at that time objedct have all properties regarding that class.
some times we want to pass object related all information to another function or Thread so you can change related parameters of that object inside that function.
More Handy when --> One Function or Thread for many object 

 when start the thread,  you want to pass objecect as a argument at that time this is very useful -- so thread work according that object.
 
 ENUM DATA_TYPE DECALARED IN THREAD.H FILE FOR STATUS
 0 = IN ACTIVE
 1 = READY
 2 = RUNNING
 4 = WAITING DELAY
 5 = WAITING FOR JOIN 
 16 = DELETED / TERMINATED
 etc...VISIT THREAD.H FILE 
 
 LINK : https://os.mbed.com/docs/mbed-os/v6.1/mbed-os-api-doxy/_thread_8h_source.html
 
 */ 
 
 //PROGRAM : AFTER 5 SEC LED BLINKING OFF & FLAGG MECHANISM

#include "mbed.h"
#include "rtos.h"

Thread thread;  //CREATE GLOBAL THREAD
DigitalOut led1(LED1);  //CREATE OBJECT
volatile bool running = true;  // FLAG TYPE VARIABLE

// Blink function toggles the led in a long running loop
void blink(DigitalOut *led)
{
    while (running) {  // WHILE FLAG SET
    
        *led = !*led;  //TOGGLE
        ThisThread::sleep_for(1000);//SLEEP
        
        uint32_t status = thread.get_state();   //GET THE STATUS OF THREAD
        printf("\n Thread status FROM INSIDE THREAD = %d",(uint32_t)status);  //PRINT STATUS ON SERIAL TERMINAL
    }
}

// Spawns a thread to run blink for 5 seconds
int main()
{
    thread.start(callback(blink, &led1));  //FUNCTION ATTACHMENT + THREAD START + ARGUMENT PASS
    ThisThread::sleep_for(5000); //MAIN THREAD SLEEP
    running = false;  //FLAG FALSE AFTER AWAKING MAIN THREAD
    uint32_t status = thread.get_state();
    printf("\n A-- Thread status FROM MAIN = %d",(uint32_t)status);  //PRINT STATUS ON SERIAL TERMINAL
    status = thread.get_state();
    printf("\n B-- Thread status FROM MAIN = %d",(uint32_t)status);  //PRINT STATUS ON SERIAL TERMINAL
    
    thread.terminate(); //Terminate thread for free stack
    status = thread.get_state();
    printf("\n C-- Thread status FROM MAIN = %d",(uint32_t)status);  //PRINT STATUS ON SERIAL TERMINAL
    thread.join();  // WHILEATE STATEMENT NOT USE IN main(), thats why join use .
    while(1)
    {
    status = thread.get_state();
    printf("\n D-- Thread status FROM MAIN = %d",(uint32_t)status); 
        }

}