/*SEMAPHORE PART 1
USE OF WAIT_UNTIL() FUNCTIONS IN SEMAPHORE
TIME BASED LOCKING + SEMAPHORE SIGNAL BASED LOCKING
THIS PROGRAM IS FOR CLEARING CONCEPT OF TIME BASED SIGNALING OF SEMAPHORE
*/

//USE SERIAL TERMINAL WITH 9600 BAUD RATE  8-N-1 FORMAT

//Created by : JAYDEEP SHAH  --radhey04ec@gmail.com


//Library Added :::::
#include "mbed.h"

DigitalOut led(LED1);  // ON BOARD LED
InterruptIn btn(USER_BUTTON);  // ON BOARD BUTTON  PORT PC_13 
//INTERRUPT REGISTERATION

Semaphore updates(0);  //SEMAPHORE OBJECT CREATE = SHARE RESOURCE 0
//NO SHARE RESOURCE ONLY ISR

void do_something() {        //ISR FUNCTION
  // release the semaphore
  updates.release();   // NOW V=1
}

int main() {
  btn.fall(&do_something);  //FUNCTION CALL WHEN FALL EDGE OF BUTTON - ISR

  while (1) {  //LOOP FOREVER
    // wait for the semaphore to be released from the ISR
    uint32_t v = updates.wait_until(30000);    //RETURN STORE IN V

    // now this runs on the main thread, and is safe

    if(v==1)  //THIS ONLY RUN WHEN BUTTON PRESS & SEMAPHORE RELEASE BY 1
{
      led = !led;    //LED TOGGLE
      printf("Toggle LED! V= %d \r\n",v);  //SERIAL PRINT  V  === 0 AGAIN
    }
    
    if(v == 0)  // This Function run after 30 sec of Power on/RST Continue   -- NO matter button press or not
    {
    printf("\n TIMER RELEASE SEMAPHORE V = %d \r\n",v);
  }
  
  }
}